<?php
/**
 * Introduction section
 *
 * This is the template for the content of about_us section
 *
 * @package Theme Palace
 * @subpackage Camera Store
 * @since Camera Store 1.0.0
 */
if ( ! function_exists( 'camera_store_add_about_section' ) ) :
    /**
    * Add about_us section
    *
    *@since Camera Store 1.0.0
    */
    function camera_store_add_about_section() {
        
        // Check if client is enabled on frontpage
        if ( get_theme_mod( 'about_section_enable' ) == false ) {
            return false;
        }

        // Get about_us section details
        $section_details = array();
        $section_details = apply_filters( 'camera_store_filter_about_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render about_us section now.
        camera_store_render_about_section( $section_details );
    }

endif;

if ( ! function_exists( 'camera_store_get_about_section_details' ) ) :
    /**
    * about_us section details.
    *
    * @since Camera Store 1.0.0
    * @param array $input about_us section details.
    */
    function camera_store_get_about_section_details( $input ) {
        
        $content = array();
        $page_id = ! empty( get_theme_mod( 'about_content_page' ) ) ? get_theme_mod( 'about_content_page' ) : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = stortech_trim_content( 25 );
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// about_us section content details.
add_filter( 'camera_store_filter_about_section_details', 'camera_store_get_about_section_details' );


if ( ! function_exists( 'camera_store_render_about_section' ) ) :
  /**
   * Start about_us section
   *
   * @return string about_us content
   * @since Camera Store 1.0.0
   *
   */
   function camera_store_render_about_section( $content_details = array() ) {

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="stortech_about_section">

        <div id="gallery" class="page-section no-padding-top">
            <div class="wrapper">

                <?php foreach ($content_details as $content ): ?>

                    <article class="has-post-thumbnail">
                        <div class="featured-image" style="background-image:url('<?php echo esc_url( $content['image'] ); ?>')"></div>

                        <div class="entry-container">
                            <div class="section-header">
                                <h2 class="section-title"><?php echo esc_html( $content['title'] ) ?></h2>
                            </div><!-- .section-header -->

                            <div class="entry-content">
                                <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                            </div><!-- .entry-content -->

                            <?php if( !empty( get_theme_mod( 'about_btn_label' ) ) ): ?>
                                <div class="read-more">
                                <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn btn-fill"><?php echo esc_html( get_theme_mod( 'about_btn_label' ) ); ?></a>
                                </div><!-- .read-more -->
                            <?php endif; ?>
                        </div>
                    </article>

                <?php endforeach; ?>

            </div><!-- about-us -->
        </div>  

        </div>      
              
<?php    }
endif;