<?php
/**
 * Product Zoom Section options
 *
 * @package Theme Palace
 * @subpackage Camera Store
 * @since Camera Store 1.0.0
 */

// Add Product Zoom section
$wp_customize->add_section( 'stortech_zoom_section', array(
	'title'             => esc_html__( 'Product Zoom','camera-store' ),
	'description'       => esc_html__( 'Product Zoom Section options.', 'camera-store' ),
	'panel'             => 'stortech_front_page_panel',
	'priority' 			=> 52,
) );

// Product Zoom content enable control and setting
$wp_customize->add_setting( 'zoom_section_enable', array(
	'sanitize_callback' => 'stortech_sanitize_switch_control',
	'default' => false,
) );

$wp_customize->add_control( new Camera_Store_Switch_Control( $wp_customize, 'zoom_section_enable', array(
	'label'             => esc_html__( 'Product Zoom Section Enable', 'camera-store' ),
	'section'           => 'stortech_zoom_section',
	'on_off_label' 		=> stortech_switch_options(),
) ) );

// zoom pages drop down chooser control and setting
$wp_customize->add_setting( 'zoom_content_page', array(
	'sanitize_callback' => 'stortech_sanitize_page',
) );

$wp_customize->add_control( new Camera_Store_Dropdown_Chooser( $wp_customize, 'zoom_content_page', array(
	'label'             => esc_html__( 'Select Page', 'camera-store' ), 
	'section'           => 'stortech_zoom_section',
	'choices'			=> stortech_page_choices(),
	'active_callback'	=> 'camera_store_is_zoom_section_enable',
) ) );

$wp_customize->add_setting( 'zoom_btn_label', array(
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
	'default'			=> __('Explore More', 'camera-store'),
) );

$wp_customize->add_control( 'zoom_btn_label', array(
	'label'           	=>  esc_html__( 'Button Lable', 'camera-store' ),
	'section'        	=> 'stortech_zoom_section',
	'active_callback' 	=> 'camera_store_is_zoom_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'zoom_btn_label', array(
		'selector'            => '#zoom .read-more a',
		'settings'            => 'zoom_btn_label',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'camera_store_zoom_btn_label_partial',
    ) );
}