<?php
/**
 * Introduction Section options
 *
 * @package Theme Palace
 * @subpackage Camera Store
 * @since Camera Store 1.0.0
 */

if ( !class_exists('WooCommerce') ) {
	return;
}


// Add Introduction section
$wp_customize->add_section( 'stortech_introduction_section', array(
	'title'             => esc_html__( 'Introduction','camera-store' ),
	'description'       => esc_html__( 'Introduction Section options.', 'camera-store' ),
	'panel'             => 'stortech_front_page_panel',
	'priority' 			=> 11,
) );

// Introduction content enable control and setting
$wp_customize->add_setting( 'introduction_section_enable', array(
	'sanitize_callback' => 'stortech_sanitize_switch_control',
	'default' => false,
) );

$wp_customize->add_control( new Camera_Store_Switch_Control( $wp_customize, 'introduction_section_enable', array(
	'label'             => esc_html__( 'Introduction Section Enable', 'camera-store' ),
	'section'           => 'stortech_introduction_section',
	'on_off_label' 		=> stortech_switch_options(),
) ) );

$wp_customize->add_setting( 'introduction_product_content_product', array(
	'sanitize_callback' => 'stortech_sanitize_page',
) );

$wp_customize->add_control( new Camera_Store_Dropdown_Chooser( $wp_customize, 'introduction_product_content_product', array(
	'label'             => esc_html__( 'Select Product', 'camera-store' ), 
	'section'           => 'stortech_introduction_section',
	'choices'			=> stortech_product_choices(),
	'active_callback'	=> 'camera_store_is_introduction_section_enable',
) ) );

// stortech title setting and control
$wp_customize->add_setting( 'introduction_subtitle', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default' 			=> __('Capture your best moments', 'camera-store'),
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'introduction_subtitle', array(
	'label'           	=> esc_html__( 'Subtitle', 'camera-store' ),
	'section'        	=> 'stortech_introduction_section',
	'active_callback' 	=> 'camera_store_is_introduction_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'introduction_subtitle', array(
		'selector'            => '#introduction span.sub-title',
		'settings'            => 'introduction_subtitle',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'camera_store_introduction_subtitle_partial',
    ) );
}

// stortech title setting and control
$wp_customize->add_setting( 'introduction_product_text', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default' 			=> __('Starting at', 'camera-store'),
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'introduction_product_text', array(
	'label'           	=> esc_html__( 'Product Text', 'camera-store' ),
	'section'        	=> 'stortech_introduction_section',
	'active_callback' 	=> 'camera_store_is_introduction_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'introduction_product_text', array(
		'selector'            => '#introduction span.product-text',
		'settings'            => 'introduction_product_text',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'camera_store_introduction_product_text_partial',
    ) );
}