<?php
/**
 * Product Design Section options
 *
 * @package Theme Palace
 * @subpackage Camera Store
 * @since Camera Store 1.0.0
 */

// Add Product Design section
$wp_customize->add_section( 'stortech_design_section', array(
	'title'             => esc_html__( 'Product Design','camera-store' ),
	'description'       => esc_html__( 'Product Design Section options.', 'camera-store' ),
	'panel'             => 'stortech_front_page_panel',
	'priority' 			=> 51,
) );

// Product Design content enable control and setting
$wp_customize->add_setting( 'design_section_enable', array(
	'sanitize_callback' => 'stortech_sanitize_switch_control',
	'default' => false,
) );

$wp_customize->add_control( new Camera_Store_Switch_Control( $wp_customize, 'design_section_enable', array(
	'label'             => esc_html__( 'Product Design Section Enable', 'camera-store' ),
	'section'           => 'stortech_design_section',
	'on_off_label' 		=> stortech_switch_options(),
) ) );

// design pages drop down chooser control and setting
$wp_customize->add_setting( 'design_content_page', array(
	'sanitize_callback' => 'stortech_sanitize_page',
) );

$wp_customize->add_control( new Camera_Store_Dropdown_Chooser( $wp_customize, 'design_content_page', array(
	'label'             => esc_html__( 'Select Page', 'camera-store' ), 
	'section'           => 'stortech_design_section',
	'choices'			=> stortech_page_choices(),
	'active_callback'	=> 'camera_store_is_design_section_enable',
) ) );

$wp_customize->add_setting( 'design_btn_label', array(
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
	'default'			=> __('Learn More', 'camera-store'),
) );

$wp_customize->add_control( 'design_btn_label', array(
	'label'           	=>  esc_html__( 'Button Lable', 'camera-store' ),
	'section'        	=> 'stortech_design_section',
	'active_callback' 	=> 'camera_store_is_design_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'design_btn_label', array(
		'selector'            => '#design .read-more a',
		'settings'            => 'design_btn_label',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'camera_store_design_btn_label_partial',
    ) );
}