<?php
/**
 * CTA Section options
 *
 * @package Theme Palace
 * @subpackage Camera Store
 * @since Camera Store 1.0.0
 */

// Add CTA section
$wp_customize->add_section( 'stortech_cta_section', array(
	'title'             => esc_html__( 'CTA','camera-store' ),
	'description'       => esc_html__( 'CTA Section options.', 'camera-store' ),
	'panel'             => 'stortech_front_page_panel',
	'priority' 			=> 13,
) );

// CTA content enable control and setting
$wp_customize->add_setting( 'cta_section_enable', array(
	'sanitize_callback' => 'stortech_sanitize_switch_control',
	'default' => false,
) );

$wp_customize->add_control( new Camera_Store_Switch_Control( $wp_customize, 'cta_section_enable', array(
	'label'             => esc_html__( 'CTA Section Enable', 'camera-store' ),
	'section'           => 'stortech_cta_section',
	'on_off_label' 		=> stortech_switch_options(),
) ) );

// cta pages drop down chooser control and setting
$wp_customize->add_setting( 'cta_content_page', array(
	'sanitize_callback' => 'stortech_sanitize_page',
) );

$wp_customize->add_control( new Camera_Store_Dropdown_Chooser( $wp_customize, 'cta_content_page', array(
	'label'             => esc_html__( 'Select Page', 'camera-store' ), 
	'section'           => 'stortech_cta_section',
	'choices'			=> stortech_page_choices(),
	'active_callback'	=> 'camera_store_is_cta_section_enable',
) ) );