<?php

function camera_store_customize_register( $wp_customize ) {

class Camera_Store_Switch_Control extends WP_Customize_Control{

		public $type = 'switch';

		public $on_off_label = array();

		public function __construct( $manager, $id, $args = array() ){
	        $this->on_off_label = $args['on_off_label'];
	        parent::__construct( $manager, $id, $args );
	    }

		public function render_content(){
	    ?>
		    <span class="customize-control-title">
				<?php echo esc_html( $this->label ); ?>
			</span>

			<?php if( $this->description ){ ?>
				<span class="description customize-control-description">
				<?php echo wp_kses_post( $this->description ); ?>
				</span>
			<?php } ?>

			<?php
				$switch_class = ( $this->value() == 'true' ) ? 'switch-on' : '';
				$on_off_label = $this->on_off_label;
			?>
			<div class="onoffswitch <?php echo esc_attr( $switch_class ); ?>">
				<div class="onoffswitch-inner">
					<div class="onoffswitch-active">
						<div class="onoffswitch-switch"><?php echo esc_html( $on_off_label['on'] ) ?></div>
					</div>

					<div class="onoffswitch-inactive">
						<div class="onoffswitch-switch"><?php echo esc_html( $on_off_label['off'] ) ?></div>
					</div>
				</div>	
			</div>
			<input <?php $this->link(); ?> type="hidden" value="<?php echo esc_attr( $this->value() ); ?>"/>
			<?php
	    }
	}

	class Camera_Store_Dropdown_Chooser extends WP_Customize_Control{

		public $type = 'dropdown_chooser';

		public function render_content(){
			if ( empty( $this->choices ) )
	                return;
			?>
	            <label>
	                <span class="customize-control-title">
	                	<?php echo esc_html( $this->label ); ?>
	                </span>

	                <?php if($this->description){ ?>
		            <span class="description customize-control-description">
		            	<?php echo wp_kses_post($this->description); ?>
		            </span>
		            <?php } ?>

	                <select class="camera-store-chosen-select" <?php $this->link(); ?>>
	                    <?php
	                    foreach ( $this->choices as $value => $label )
	                        echo '<option value="' . esc_attr( $value ) . '"' . selected( $this->value(), $value, false ) . '>' . esc_html( $label ) . '</option>';
	                    ?>
	                </select>
	            </label>
			<?php
		}
	}

	//customizer section
	require get_theme_file_path() . '/inc/customizer/introduction.php';

	require get_theme_file_path() . '/inc/customizer/about.php';

	require get_theme_file_path() . '/inc/customizer/cta.php';

	require get_theme_file_path() . '/inc/customizer/gallery.php';

	require get_theme_file_path() . '/inc/customizer/service.php';

	require get_theme_file_path() . '/inc/customizer/design.php';

	require get_theme_file_path() . '/inc/customizer/zoom.php';

	require get_theme_file_path() . '/inc/customizer/similar.php';

}
add_action( 'customize_register', 'camera_store_customize_register' );


/*=============Active Callback=====================*/

function camera_store_is_introduction_section_enable( $control ) {
	return ( $control->manager->get_setting( 'introduction_section_enable' )->value() );
}

function camera_store_is_about_section_enable( $control ) {
	return ( $control->manager->get_setting( 'about_section_enable' )->value() );
}

function camera_store_is_cta_section_enable( $control ) {
	return ( $control->manager->get_setting( 'cta_section_enable' )->value() );
}

function stortech_is_gallery_section_enable( $control ) {
	return ( $control->manager->get_setting( 'gallery_section_enable' )->value() );
}

function camera_store_is_design_section_enable( $control ) {
	return ( $control->manager->get_setting( 'design_section_enable' )->value() );
}

function camera_store_is_zoom_section_enable( $control ) {
	return ( $control->manager->get_setting( 'zoom_section_enable' )->value() );
}

function camera_store_is_similar_section_enable( $control ) {
	return ( $control->manager->get_setting( 'similar_section_enable' )->value() );
}

/*=============partial refresh=====================*/

if ( ! function_exists( 'camera_store_introduction_subtitle_partial' ) ) :
    // introduction_subtitle
    function camera_store_introduction_subtitle_partial() {
        return esc_html( get_theme_mod( 'introduction_subtitle' ) );
    }
endif;

if ( ! function_exists( 'camera_store_introduction_product_text_partial' ) ) :
    // introduction_product_text
    function camera_store_introduction_product_text_partial() {
        return esc_html( get_theme_mod( 'introduction_product_text' ) );
    }
endif;

if ( ! function_exists( 'camera_store_about_btn_label_partial' ) ) :
    // about_btn_label
    function camera_store_about_btn_label_partial() {
        return esc_html( get_theme_mod( 'about_btn_label' ) );
    }
endif;

if ( ! function_exists( 'camera_store_gallery_title_partial' ) ) :
    // gallery_title
    function camera_store_gallery_title_partial() {
        return esc_html( get_theme_mod( 'gallery_title' ) );
    }
endif;

if ( ! function_exists( 'camera_store_gallery_subtitle_partial' ) ) :
    // gallery_subtitle
    function camera_store_gallery_subtitle_partial() {
        return esc_html( get_theme_mod( 'gallery_subtitle' ) );
    }
endif;

if ( ! function_exists( 'camera_store_product_service_title_partial' ) ) :
    // product_service_title
    function camera_store_product_service_title_partial() {
        return esc_html( get_theme_mod( 'product_service_title' ) );
    }
endif;

if ( ! function_exists( 'camera_store_product_service_subtitle_partial' ) ) :
    // product_service_subtitle
    function camera_store_product_service_subtitle_partial() {
        return esc_html( get_theme_mod( 'product_service_subtitle' ) );
    }
endif;

if ( ! function_exists( 'camera_store_design_btn_label_partial' ) ) :
    // design_btn_label
    function camera_store_design_btn_label_partial() {
        return esc_html( get_theme_mod( 'design_btn_label' ) );
    }
endif;

if ( ! function_exists( 'camera_store_zoom_btn_label_partial' ) ) :
    // zoom_btn_label
    function camera_store_zoom_btn_label_partial() {
        return esc_html( get_theme_mod( 'zoom_btn_label' ) );
    }
endif;

if ( ! function_exists( 'stortech_similar_title_partial' ) ) :
    // similar_title
    function stortech_similar_title_partial() {
        return esc_html( get_theme_mod( 'similar_title' ) );
    }
endif;

if ( ! function_exists( 'stortech_similar_btn_label_partial' ) ) :
    // similar_btn_label
    function stortech_similar_btn_label_partial() {
        return esc_html( get_theme_mod( 'similar_btn_label' ) );
    }
endif;