<?php
/**
 * Home Section 1 Template
 *
 * @package CA BiZ Startup
 */

// Check if the About section is enabled
$ca_biz_startup_section_one = get_theme_mod('ca_biz_startup_about_enable');
if ('Disable' == $ca_biz_startup_section_one) {
    return;
}
?>

<section id="about" class="about-section">
  <div class="container-fluid">
    <div class="section-heading-main">
      <?php 
      // Display the section title if set
      if (get_theme_mod('ca_biz_startup_about_title', true) != '') { ?>
        <h3><?php echo esc_html(get_theme_mod('ca_biz_startup_about_title')); ?></h3>
      <?php } ?>
    </div>
    <div class="row">
      <div class="col-lg-6 col-6">
        <?php 
        // Display the about image if set
        if (get_theme_mod('ca_biz_startup_aboutimage_section') != '') { ?>
          <img src="<?php echo esc_url(get_theme_mod('ca_biz_startup_aboutimage_section')); ?>" alt="About Image">
        <?php } ?>
      </div>
      <div class="col-lg-6 col-6">
        <div class="about-box">
          <?php 
          // Display the about name if set
          if (get_theme_mod('ca_biz_startup_about_name') != '') { ?>
            <h3><?php echo esc_html(get_theme_mod('ca_biz_startup_about_name')); ?></h3>
          <?php } ?>
          
          <?php 
          // Display the second title if set
          if (get_theme_mod('ca_biz_startup_about_title_second') != '') { ?>
            <h4><?php echo esc_html(get_theme_mod('ca_biz_startup_about_title_second')); ?></h4>
          <?php } ?>

          <?php 
          // Display the paragraph if set
          if (get_theme_mod('ca_biz_startup_about_para') != '') { ?>
            <p><?php echo esc_html(get_theme_mod('ca_biz_startup_about_para')); ?></p>
          <?php } ?>

          <?php 
          // Display the button if the text is set
          if (get_theme_mod('ca_biz_startup_about_btn_text') != '') { ?>
            <div class="theme-btn">
              <a href="<?php echo esc_url(get_theme_mod('ca_biz_startup_about_btn_text_url')); ?>"><?php echo esc_html(get_theme_mod('ca_biz_startup_about_btn_text')); ?></a>
            </div>
          <?php } ?>
        </div>
      </div>
    </div>
  </div>
</section>
