<?php

// about theme info
add_action( 'admin_menu', 'ca_biz_startup_gettingstarted_page' );
function ca_biz_startup_gettingstarted_page() {      
    add_theme_page( esc_html__('CA Biz Startup', 'ca-biz-startup'), esc_html__('All About CA Biz Startup', 'ca-biz-startup'), 'edit_theme_options', 'ca_biz_startup_mainpage', 'ca_biz_startup_main_content');   
}

function ca_biz_startup_discount_notice() {
    global $pagenow;
    if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) { ?>
        <div class="notice getting_started">
            <div class="notice-content">
                <p><?php esc_html_e( '🎉 Thank You For Choosing CA WP Themes!', 'ca-biz-startup' ); ?></p>
                
                <h2><?php esc_html_e( '🚀 Get Started with Your Free Theme!', 'ca-biz-startup' ); ?></h2>
                
                <p><?php esc_html_e( "Here are some useful links to help you set up your theme quickly:", 'ca-biz-startup' ); ?></p>
                
                <div class="info-link">
                    <a href="<?php echo esc_url( 'https://cawpthemes.com/ca-biz-startup-free-wordpress-theme/' ); ?>" target="_blank">
                        <?php esc_html_e( '🎨 View Free Theme Details', 'ca-biz-startup' ); ?>
                    </a>
                </div>
                
                <div class="info-link">
                    <a href="<?php echo esc_url( 'https://cawpthemes.com/docs/ca-biz-startup-free-theme-documentation/' ); ?>" target="_blank">
                        <?php esc_html_e( '📖 Read Theme Documentation', 'ca-biz-startup' ); ?>
                    </a>
                </div>

                <h2><?php esc_html_e( '🔥 Upgrade to Pro for More Amazing Features!', 'ca-biz-startup' ); ?></h2>
                
                <p><?php esc_html_e( "Unlock the full potential of your website with our premium version! 🚀", 'ca-biz-startup' ); ?></p>
                
                <div class="info-link">
                    <a href="<?php echo esc_url( CA_BIZ_STARTUP_PRO_DOCUMENTATION ); ?>" target="_blank">
                        <?php esc_html_e( '📖 Pro Documentation', 'ca-biz-startup' ); ?>
                    </a>
                </div>

                <div class="info-link">
                    <a href="<?php echo esc_url( CA_BIZ_STARTUP_PRO_URL ); ?>" target="_blank">
                        <?php esc_html_e( '🚀 Upgrade to Pro', 'ca-biz-startup' ); ?>
                    </a>
                </div>

                <div class="info-link">
                    <a href="<?php echo esc_url( CA_BIZ_STARTUP_PRO_DEMO ); ?>" target="_blank">
                        <?php esc_html_e( '✨ Premium Demo', 'ca-biz-startup' ); ?>
                    </a>
                </div>

                <h2><?php esc_html_e( '🔥 Limited Time Offer – Flat 15% OFF on Pro Themes!', 'ca-biz-startup' ); ?></h2>
                
                <p><?php esc_html_e( "Upgrade today and get 15% off! Don't miss this exclusive deal! 💰", 'ca-biz-startup' ); ?></p>
                
                <ul class="discount-benefits">
                    <li>✅ <?php esc_html_e('SEO Optimized & Speed Fast 🚀', 'ca-biz-startup'); ?></li>
                    <li>✅ <?php esc_html_e('Fully Responsive & Mobile-Friendly 📱', 'ca-biz-startup'); ?></li>
                    <li>✅ <?php esc_html_e('Customizer Support for Easy Customization 🎨', 'ca-biz-startup'); ?></li>
                    <li>✅ <?php esc_html_e('Premium Features & Regular Updates 🔥', 'ca-biz-startup'); ?></li>
                </ul>
                
                <p class="discount-code">
                    <?php esc_html_e('👉 Use Code:', 'ca-biz-startup'); ?> 
                    <span>SAVE15</span> 
                    <?php esc_html_e(' at Checkout', 'ca-biz-startup'); ?>
                </p>
                
                <div class="info-link">
                    <a href="<?php echo esc_url( CA_BIZ_STARTUP_PRO_URL ); ?>" target="_blank">
                        <?php esc_html_e( '🛒 Shop Now', 'ca-biz-startup' ); ?>
                    </a>
                </div>

                <p class="offer-expiry"><?php esc_html_e('📅 Hurry! Offer ends soon.', 'ca-biz-startup' ); ?></p>
            </div>
        </div>
    <?php }
}

add_action( 'admin_notices', 'ca_biz_startup_discount_notice' );

// Add a Custom CSS file to WP Admin Area
function ca_biz_startup_admin_page_theme_style() {
   wp_enqueue_style('ca-biz-startup-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/getstarted/getstarted.css');
}
add_action('admin_enqueue_scripts', 'ca_biz_startup_admin_page_theme_style');

// About Theme Info
function ca_biz_startup_main_content() { 

    // Custom function about theme customizer

    $return = add_query_arg( array()) ;
    $theme = wp_get_theme( 'ca-biz-startup' );
?>

<div class="theme-discount-banner">
    <h2><?php esc_html_e('🚀 Limited Time Offer – Flat 15% OFF on All Premium WordPress Themes! 🎉', 'ca-biz-startup'); ?></h2>
    <p><?php esc_html_e('Upgrade your website with our stunning, high-performance WordPress themes at an exclusive 15% discount! 💰✨', 'ca-biz-startup'); ?></p>
    
    <ul class="discount-benefits">
        <li>✅ <?php esc_html_e('SEO Optimized & Speed Fast 🚀', 'ca-biz-startup'); ?></li>
        <li>✅ <?php esc_html_e('Fully Responsive & Mobile-Friendly 📱', 'ca-biz-startup'); ?></li>
        <li>✅ <?php esc_html_e('Customizer Support for Easy Customization 🎨', 'ca-biz-startup'); ?></li>
        <li>✅ <?php esc_html_e('Premium Features & Regular Updates 🔥', 'ca-biz-startup'); ?></li>
    </ul>
    
    <p class="discount-code"><?php esc_html_e('👉 Use Code: ', 'ca-biz-startup'); ?> <span>SAVE15</span> <?php esc_html_e(' at Checkout', 'ca-biz-startup'); ?></p>
    
    <a href="https://cawpthemes.com/ca-biz-startup-premium-wordpress-theme/" class="cta-button"><?php esc_html_e('Shop Now 🚀', 'ca-biz-startup'); ?></a>
    
    <p class="offer-expiry"><?php esc_html_e('📅 Hurry! Offer ends soon.', 'ca-biz-startup'); ?></p>
</div>

<div class="admin-main-box">
    <div class="admin-left-box">
        <h2><?php esc_html_e('Welcome to CA Biz Startup Theme', 'ca-biz-startup'); ?> <span class="version"><?php $theme_info = wp_get_theme();
echo $theme_info->get( 'Version' );?></span></h2>
        <p><?php esc_html_e('CA WP Themes is a premium WordPress theme development company that provides high-quality themes for various types of websites. They specialize in creating themes for businesses, eCommerce, portfolios, blogs, and many more. Their themes are easy to use and customize, making them perfect for those who want to create a professional-looking website without any coding skills.', 'ca-biz-startup'); ?></p>
        <p><?php esc_html_e('CA WP Themes offers a wide range of themes that are designed to be responsive and compatible with the latest versions of WordPress. Our themes are also SEO optimized, ensuring that your website will rank well on search engines. They come with a variety of features such as customizable widgets, social media integration, and custom page templates.', 'ca-biz-startup'); ?></p>
        <p><?php esc_html_e('One of the unique things about CA WP Themes is their focus on providing excellent customer support. They have a dedicated team of support staff who are available 24/7 to help customers with any issues they may encounter. Their support team is knowledgeable and friendly, ensuring that customers receive the best possible experience.', 'ca-biz-startup'); ?></p>
    </div>
    <div class="admin-right-box">
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Buy CA Biz Startup Premium Theme', 'ca-biz-startup'); ?></h4>
            <p><?php esc_html_e('Now the Premium Version is only at $39.99 with Lifetime Access!Grab the deal now!', 'ca-biz-startup'); ?></p>
            <div class="info-link">
                <a href="<?php echo esc_url( CA_BIZ_STARTUP_PRO_URL ); ?>" target="_blank"> <?php esc_html_e('Upgrade to Pro', 'ca-biz-startup'); ?></a>
            </div>
        </div>
        <hr>
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Premium Theme Demo', 'ca-biz-startup'); ?></h4>
            <div class="info-link">
                <a href="<?php echo esc_url( CA_BIZ_STARTUP_PRO_DEMO ); ?>" target="_blank"> <?php esc_html_e('Demo', 'ca-biz-startup'); ?></a>
            </div>
        </div>
        <hr>
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Need Support? / Contact Us', 'ca-biz-startup'); ?></h4>
            <div class="info-link">
                <a href="<?php echo esc_url( CA_BIZ_STARTUP_PRO_SUPPORT ); ?>" target="_blank"> <?php esc_html_e('Contact Us', 'ca-biz-startup'); ?></a>
            </div>
        </div>
        <hr>
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Documentation', 'ca-biz-startup'); ?></h4>
            <div class="info-link">
                <a href="<?php echo esc_url( CA_BIZ_STARTUP_PRO_DOCUMENTATION ); ?>" target="_blank"> <?php esc_html_e('Docs', 'ca-biz-startup'); ?></a>
            </div>
        </div>
        <hr>
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Free Theme', 'ca-biz-startup'); ?></h4>
            <div class="info-link">
                <a href="<?php echo esc_url( CA_BIZ_STARTUP_FREE_URL ); ?>" target="_blank"> <?php esc_html_e('Demo', 'ca-biz-startup'); ?></a>
            </div>
        </div>

    </div>
</div>
</div>

<?php } ?>
