<?php
/**
 * Add custom settings and controls to the WordPress Customizer
 */


//---------------------Code to add the Upgrade to Pro button in the Customizer----------

function ca_biz_startup_customize_register_btn( $wp_customize ) {
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
    $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
    $wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

    get_template_part('inc/customizer-button/upsell-section');

    if ( isset( $wp_customize->selective_refresh ) ) {
        $wp_customize->selective_refresh->add_partial( 'blogname', array(
            'selector'        => '.site-title a',
            'render_callback' => 'ca_biz_startup_customize_partial_blogname',
        ) );
        $wp_customize->selective_refresh->add_partial( 'blogdescription', array(
            'selector'        => '.site-description',
            'render_callback' => 'ca_biz_startup_customize_partial_blogdescription',
        ) );
    }

    $wp_customize->register_section_type( 'ca_biz_startup_Customize_Upsell_Section' );

    // Register section.
    $wp_customize->add_section(
        new ca_biz_startup_Customize_Upsell_Section(
            $wp_customize,
            'theme_upsell',
            array(
                'title'    => esc_html__( 'CA Biz Startup Pro', 'ca-biz-startup' ),
                'pro_text' => esc_html__( 'Upgrade To Pro', 'ca-biz-startup' ),
                'pro_url'  => 'https://cawpthemes.com/ca-biz-startup-premium-wordpress-theme/',
                'priority' => 1,
            )
        )
    );
}
add_action( 'customize_register', 'ca_biz_startup_customize_register_btn' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function ca_biz_startup_customize_partial_blogname() {
    bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function ca_biz_startup_customize_partial_blogdescription() {
    bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function ca_biz_startup_customize_preview_js() {
    wp_enqueue_script( 'ca-biz-startup-customizer', get_template_directory_uri() . '/inc/customizer-button/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'ca_biz_startup_customize_preview_js' );

/**
 * Customizer control scripts and styles.
 *
 * @since 1.0.0
 */
function ca_biz_startup_customizer_control_scripts() {

    wp_enqueue_style( 'ca-biz-startup-customize-controls', get_template_directory_uri() . '/inc/customizer-button/customize-controls.css', '', '1.0.0' );

    wp_enqueue_script( 'ca-biz-startup-customize-controls', get_template_directory_uri() . '/inc/customizer-button/customize-controls.js', array( 'customize-controls' ), '1.0.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'ca_biz_startup_customizer_control_scripts', 0 );


//---------------------Code to add the Upgrade to Pro button in the Customizer End----------
//------------------Theme Information--------------------

function ca_biz_startup_customize_register( $wp_customize ) {


      // Add a custom setting for the Site Identity color
  $wp_customize->add_setting( 'ca_biz_startup_site_identity_color', array(
    'default' => '#000',
    'sanitize_callback' => 'sanitize_hex_color',
  ) );

  // Add a custom control for the primary color
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ca_biz_startup_site_identity_color', array(
    'label' => __( 'Site Identity Color', 'ca-biz-startup' ),
    'section' => 'title_tagline',
    'settings' => 'ca_biz_startup_site_identity_color',
  ) ) );


  // Add a custom setting for the Site Identity color
  $wp_customize->add_setting( 'ca_biz_startup_site_identity_tagline_color', array(
    'default' => '#000',
    'sanitize_callback' => 'sanitize_hex_color',
  ) );

  // Add a custom control for the primary color
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ca_biz_startup_site_identity_tagline_color', array(
    'label' => __( 'Tagline Color', 'ca-biz-startup' ),
    'section' => 'title_tagline',
    'settings' => 'ca_biz_startup_site_identity_tagline_color',
  ) ) );

//------------------Site Identity Ends---------------------

  
  // Add a custom setting for the primary color
  $wp_customize->add_setting( 'ca_biz_startup_primary_color', array(
    'default' => '#008080',
    'sanitize_callback' => 'sanitize_hex_color',
  ) );

  // Add a custom control for the primary color
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ca_biz_startup_primary_color', array(
    'label' => __( 'Primary Color', 'ca-biz-startup' ),
    'section' => 'colors',
    'settings' => 'ca_biz_startup_primary_color',
  ) ) );

  //-----------------------------------Home Front Page-------------------------------

  $wp_customize->add_panel( 'ca_biz_startup_panel', array(
    'title'    => __( 'Front Page Settings', 'ca-biz-startup' ),
    'priority' => 6,
  ) );


  //-------------------------------------Banner Image Section--------------

      $wp_customize->add_section( 'ca_biz_startup_section_banner', array(
        'title'    => __( 'Home First Section', 'ca-biz-startup' ),
        'priority' => 8,
        'panel'    => 'ca_biz_startup_panel',
    ) );


  //-----------------Enable Option banner-------------

  $wp_customize->add_setting('ca_biz_startup_section_banner',array(
      'default' => 'Enable',
      'sanitize_callback' => 'ca_biz_startup_sanitize_choices'
  ));
  $wp_customize->add_control('ca_biz_startup_section_banner',array(
        'type' => 'radio',
        'label' => __('Do you want this section', 'ca-biz-startup'),
        'section' => 'ca_biz_startup_section_banner',
        'choices' => array(
            'Enable' => __('Enable', 'ca-biz-startup'),
            'Disable' => __('Disable', 'ca-biz-startup')
  )));

  $wp_customize->add_setting('ca_biz_startup_section_bannerimage_section',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'ca_biz_startup_section_bannerimage_section',array(
    'label' => __('Section Background Image','ca-biz-startup'),
    'description' => __('Dimention 1600 * 600','ca-biz-startup'),
    'section' => 'ca_biz_startup_section_banner',
    'settings' => 'ca_biz_startup_section_bannerimage_section'
  )));

    $wp_customize->add_setting('ca_biz_startup_section_bannerimage_section_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_section_bannerimage_section_title',array(
      'label' => __('Banner Title','ca-biz-startup'),
      'section' => 'ca_biz_startup_section_banner',
      'setting' => 'ca_biz_startup_section_bannerimage_section_title',
      'type'    => 'text'
    )
  ); 

      $wp_customize->add_setting('ca_biz_startup_section_bannerimage_section_text',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_section_bannerimage_section_text',array(
      'label' => __('Banner Text','ca-biz-startup'),
      'section' => 'ca_biz_startup_section_banner',
      'setting' => 'ca_biz_startup_section_bannerimage_section_text',
      'type'    => 'textarea'
    )
  );

    $wp_customize->add_setting('ca_biz_startup_banner_btn_text',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_banner_btn_text',array(
      'label' => __('Button Text','ca-biz-startup'),
      'section' => 'ca_biz_startup_section_banner',
      'setting' => 'ca_biz_startup_banner_btn_text',
      'type'    => 'text'
    )
  );


    $wp_customize->add_setting('ca_biz_startup_banner_btn_text_url',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_banner_btn_text_url',array(
      'label' => __('Button URL','ca-biz-startup'),
      'section' => 'ca_biz_startup_section_banner',
      'setting' => 'ca_biz_startup_banner_btn_text_url',
      'type'    => 'text'
    )
  );

  //----------------------------------Features Section----------------------------



    $wp_customize->add_section( 'ca_biz_startup_features', array(
        'title'    => __( 'Features Section', 'ca-biz-startup' ),
        'priority' => 10,
        'panel'    => 'ca_biz_startup_panel',
    ) );

  //-----------------Enable Option Section Features-------------

  $wp_customize->add_setting('ca_biz_startup_features_enable',array(
      'default' => 'Enable',
      'sanitize_callback' => 'ca_biz_startup_sanitize_choices'
  ));
  $wp_customize->add_control('ca_biz_startup_features_enable',array(
        'type' => 'radio',
        'label' => __('Do you want this section', 'ca-biz-startup'),
        'section' => 'ca_biz_startup_features',
        'choices' => array(
            'Enable' => __('Enable', 'ca-biz-startup'),
            'Disable' => __('Disable', 'ca-biz-startup')
  )));


  //-----------------------------Feature Image 1-----------

  $wp_customize->add_setting('ca_biz_startup_featureimage1_section',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'ca_biz_startup_featureimage1_section',array(
    'label' => __('Feature 1 Image','ca-biz-startup'),
    'description' => __('Dimention 100 * 100','ca-biz-startup'),
    'section' => 'ca_biz_startup_features',
    'settings' => 'ca_biz_startup_featureimage1_section'
  )));


    $wp_customize->add_setting('ca_biz_startup_feature1_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_feature1_title',array(
      'label' => __('Feature 1 Title','ca-biz-startup'),
      'section' => 'ca_biz_startup_features',
      'setting' => 'ca_biz_startup_feature1_title',
      'type'    => 'text'
    )
  ); 


    $wp_customize->add_setting('ca_biz_startup_feature1_text',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_feature1_text',array(
      'label' => __('Feature 1 Text','ca-biz-startup'),
      'section' => 'ca_biz_startup_features',
      'setting' => 'ca_biz_startup_feature1_text',
      'type'    => 'text'
    )
  ); 



  //-----------------------------Feature Image 2-----------

  $wp_customize->add_setting('ca_biz_startup_featureimage2_section',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'ca_biz_startup_featureimage2_section',array(
    'label' => __('Feature 2 Image','ca-biz-startup'),
    'description' => __('Dimention 100 * 100','ca-biz-startup'),
    'section' => 'ca_biz_startup_features',
    'settings' => 'ca_biz_startup_featureimage2_section'
  )));


    $wp_customize->add_setting('ca_biz_startup_feature2_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_feature2_title',array(
      'label' => __('Feature 2 Title','ca-biz-startup'),
      'section' => 'ca_biz_startup_features',
      'setting' => 'ca_biz_startup_feature2_title',
      'type'    => 'text'
    )
  ); 


    $wp_customize->add_setting('ca_biz_startup_feature2_text',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_feature2_text',array(
      'label' => __('Feature 2 Text','ca-biz-startup'),
      'section' => 'ca_biz_startup_features',
      'setting' => 'ca_biz_startup_feature2_text',
      'type'    => 'text'
    )
  ); 


  //-----------------------------Feature Image 3-----------

  $wp_customize->add_setting('ca_biz_startup_featureimage3_section',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'ca_biz_startup_featureimage3_section',array(
    'label' => __('Feature 3 Image','ca-biz-startup'),
    'description' => __('Dimention 100 * 100','ca-biz-startup'),
    'section' => 'ca_biz_startup_features',
    'settings' => 'ca_biz_startup_featureimage3_section'
  )));


    $wp_customize->add_setting('ca_biz_startup_feature3_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_feature3_title',array(
      'label' => __('Feature 3 Title','ca-biz-startup'),
      'section' => 'ca_biz_startup_features',
      'setting' => 'ca_biz_startup_feature3_title',
      'type'    => 'text'
    )
  ); 


    $wp_customize->add_setting('ca_biz_startup_feature3_text',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_feature3_text',array(
      'label' => __('Feature 3 Text','ca-biz-startup'),
      'section' => 'ca_biz_startup_features',
      'setting' => 'ca_biz_startup_feature3_text',
      'type'    => 'text'
    )
  ); 


  //----------------------------------About Section----------------------------



    $wp_customize->add_section( 'ca_biz_startup_about', array(
        'title'    => __( 'About Section', 'ca-biz-startup' ),
        'priority' => 10,
        'panel'    => 'ca_biz_startup_panel',
    ) );

  //-----------------Enable Option Section about-------------

  $wp_customize->add_setting('ca_biz_startup_about_enable',array(
      'default' => 'Enable',
      'sanitize_callback' => 'ca_biz_startup_sanitize_choices'
  ));
  $wp_customize->add_control('ca_biz_startup_about_enable',array(
        'type' => 'radio',
        'label' => __('Do you want this section', 'ca-biz-startup'),
        'section' => 'ca_biz_startup_about',
        'choices' => array(
            'Enable' => __('Enable', 'ca-biz-startup'),
            'Disable' => __('Disable', 'ca-biz-startup')
  )));

    //--------------About Title-----------------------

    $wp_customize->add_setting('ca_biz_startup_about_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_about_title',array(
      'label' => __('Section Title','ca-biz-startup'),
      'section' => 'ca_biz_startup_about',
      'setting' => 'ca_biz_startup_about_title',
      'type'    => 'text'
    )
  ); 


  //-----------------------------About Image-----------

  $wp_customize->add_setting('ca_biz_startup_aboutimage_section',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'ca_biz_startup_aboutimage_section',array(
    'label' => __('About Side Image','ca-biz-startup'),
    'description' => __('Dimention 650 * 600','ca-biz-startup'),
    'section' => 'ca_biz_startup_about',
    'settings' => 'ca_biz_startup_aboutimage_section'
  )));


    $wp_customize->add_setting('ca_biz_startup_about_name',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_about_name',array(
      'label' => __('Organization Name','ca-biz-startup'),
      'section' => 'ca_biz_startup_about',
      'setting' => 'ca_biz_startup_about_name',
      'type'    => 'text'
    )
  );


    $wp_customize->add_setting('ca_biz_startup_about_title_second',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_about_title_second',array(
      'label' => __('Second Title','ca-biz-startup'),
      'section' => 'ca_biz_startup_about',
      'setting' => 'ca_biz_startup_about_title_second',
      'type'    => 'text'
    )
  );


    $wp_customize->add_setting('ca_biz_startup_about_para',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_about_para',array(
      'label' => __('About Paragraph','ca-biz-startup'),
      'section' => 'ca_biz_startup_about',
      'setting' => 'ca_biz_startup_about_para',
      'type'    => 'textarea'
    )
  );

    $wp_customize->add_setting('ca_biz_startup_about_btn_text',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_about_btn_text',array(
      'label' => __('Button Text','ca-biz-startup'),
      'section' => 'ca_biz_startup_about',
      'setting' => 'ca_biz_startup_about_btn_text',
      'type'    => 'text'
    )
  );


    $wp_customize->add_setting('ca_biz_startup_about_btn_text_url',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_about_btn_text_url',array(
      'label' => __('Button URL','ca-biz-startup'),
      'section' => 'ca_biz_startup_about',
      'setting' => 'ca_biz_startup_about_btn_text_url',
      'type'    => 'text'
    )
  );



  //-----------------------------------------------------------------Section One (Featured Post)------------------------------------------

  $wp_customize->add_section( 'ca_biz_startup_section1', array(
        'title'    => __( 'Latest Post', 'ca-biz-startup' ),
        'priority' => 10,
        'panel'    => 'ca_biz_startup_panel',
    ) );


  //-----------------Enable Option Section One-------------

  $wp_customize->add_setting('ca_biz_startup_section1_enable',array(
      'default' => 'Enable',
      'sanitize_callback' => 'ca_biz_startup_sanitize_choices'
  ));
  $wp_customize->add_control('ca_biz_startup_section1_enable',array(
        'type' => 'radio',
        'label' => __('Do you want this section', 'ca-biz-startup'),
        'section' => 'ca_biz_startup_section1',
        'choices' => array(
            'Enable' => __('Enable', 'ca-biz-startup'),
            'Disable' => __('Disable', 'ca-biz-startup')
  )));

    //--------------Section One Title-----------------------

    $wp_customize->add_setting('ca_biz_startup_section1_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_section1_title',array(
      'label' => __('Section Title','ca-biz-startup'),
      'section' => 'ca_biz_startup_section1',
      'setting' => 'ca_biz_startup_section1_title',
      'type'    => 'text'
    )
  ); 

  //-----------Category------------

  $categories = get_categories();
  $cats = array();
  $i = 0;
  foreach($categories as $category){
    if($i==0){
      $default = $category->name;
      $i++;
    }
    $cats[$category->name] = $category->name;
  }

  $wp_customize->add_setting('ca_biz_startup_section1_category',array(
  'sanitize_callback' => 'sanitize_text_field',
  ));
  $wp_customize->add_control('ca_biz_startup_section1_category',array(
    'type'    => 'select',
    'choices' => $cats,
    'label' => __('Select Category to Display Post','ca-biz-startup'),
    'section' => 'ca_biz_startup_section1',
    'sanitize_callback' => 'sanitize_text_field',
  ));



    $wp_customize->add_setting('ca_biz_startup_section1_category_number_of_posts_setting',array(
    'default' => '6',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('ca_biz_startup_section1_category_number_of_posts_setting',array(
    'label' => __('Number of Posts','ca-biz-startup'),
    'section' => 'ca_biz_startup_section1',
    'setting' => 'ca_biz_startup_section1_category_number_of_posts_setting',
    'type'    => 'number'
  ));


  //------------------------Blog Page Settings--------------------------


  $wp_customize->add_section( 'ca_biz_startup_blogpage_settings', array(
        'title'    => __( 'Blog Page Settings', 'ca-biz-startup' ),
        'priority' => 10,
        'panel'    => 'ca_biz_startup_panel',
    ) );

    //--------------Section One Title-----------------------

    $wp_customize->add_setting('ca_biz_startup_blogpage_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('ca_biz_startup_blogpage_title',array(
      'label' => __('Blog Page Title','ca-biz-startup'),
      'section' => 'ca_biz_startup_blogpage_settings',
      'setting' => 'ca_biz_startup_blogpage_title',
      'type'    => 'text'
    )
  ); 

  //-----------Category------------

  $categories = get_categories();
  $cats = array();
  $i = 0;
  foreach($categories as $category){
    if($i==0){
      $default = $category->name;
      $i++;
    }
    $cats[$category->name] = $category->name;
  }

  $wp_customize->add_setting('ca_biz_startup_blogpage_category',array(
  'sanitize_callback' => 'sanitize_text_field',
  ));
  $wp_customize->add_control('ca_biz_startup_blogpage_category',array(
    'type'    => 'select',
    'choices' => $cats,
    'label' => __('Select Category to Display Post on Blog Page','ca-biz-startup'),
    'section' => 'ca_biz_startup_blogpage_settings',
    'sanitize_callback' => 'sanitize_text_field',
  ));



    $wp_customize->add_setting('ca_biz_startupblog_page_category_number_of_posts_setting',array(
    'default' => '18',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('ca_biz_startupblog_page_category_number_of_posts_setting',array(
    'label' => __('Number of Posts','ca-biz-startup'),
    'section' => 'ca_biz_startup_blogpage_settings',
    'setting' => 'ca_biz_startupblog_page_category_number_of_posts_setting',
    'type'    => 'number'
  )); 



  //-------------------------Footer Settings------------------------------


    $wp_customize->add_section( 'ca_biz_startup_footer', array(
        'title'    => __( 'Footer Settings', 'ca-biz-startup' ),
        'priority' => 10,
        'panel'    => 'ca_biz_startup_panel',
    ) );


  // Add a custom setting for the footer text
  $wp_customize->add_setting( 'ca_biz_startup_footer_text', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
  ) );

  // Add a custom control for the footer text
  $wp_customize->add_control( 'ca_biz_startup_footer_text', array(
    'label' => __( 'Footer Text', 'ca-biz-startup' ),
    'section' => 'ca_biz_startup_footer',
    'type' => 'text',
  ) );




    //-------------------404 Page-----------

  $wp_customize->add_section( 'ca_biz_startup_404page', array(
    'title'    => __( '404 Page Settings', 'ca-biz-startup' ),
    'priority' => 12,
    'panel'    => 'ca_biz_startup_panel',
    ) );


  // Add a custom setting for the footer text
  $wp_customize->add_setting( 'ca_biz_startup_404page_title', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
  ) );

  // Add a custom control for the footer text
  $wp_customize->add_control( 'ca_biz_startup_404page_title', array(
    'label' => __( 'Page Not Found Title', 'ca-biz-startup' ),
    'section' => 'ca_biz_startup_404page',
    'type' => 'text',
  ) );

  // Add a custom setting for the footer text
  $wp_customize->add_setting( 'ca_biz_startup_404page_text', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
  ) );

  // Add a custom control for the footer text
  $wp_customize->add_control( 'ca_biz_startup_404page_text', array(
    'label' => __( 'Page Not Found Text', 'ca-biz-startup' ),
    'section' => 'ca_biz_startup_404page',
    'type' => 'text',
  ) );


//--------------------------------------General Settings------------------------------------------

  $wp_customize->add_section( 'ca_biz_startup_general', array(
        'title'    => __( 'General Settings', 'ca-biz-startup' ),
        'panel'    => 'ca_biz_startup_panel',
    ) );

    $wp_customize->add_setting( 'ca_biz_startup_post_meta_toggle_switch_control', array(
        'default'   => true,
        'sanitize_callback' => 'sanitize_text_field', // Use a suitable sanitization function based on your needs
        'transport' => 'refresh', // or 'postMessage' for instant preview without page refresh
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'ca_biz_startup_post_meta_toggle_switch_control', array(
        'label'    => __( 'Display Time/Author', 'ca-biz-startup' ),
        'section'  => 'ca_biz_startup_general',
        'settings' => 'ca_biz_startup_post_meta_toggle_switch_control',
        'type'     => 'checkbox',
    ) ) );

    $wp_customize->add_setting( 'ca_biz_startup_post_readmore_toggle_switch_control', array(
        'default'   => true,
        'sanitize_callback' => 'sanitize_text_field', // Use a suitable sanitization function based on your needs
        'transport' => 'refresh', // or 'postMessage' for instant preview without page refresh
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'ca_biz_startup_post_readmore_toggle_switch_control', array(
        'label'    => __( 'Display Read More', 'ca-biz-startup' ),
        'section'  => 'ca_biz_startup_general',
        'settings' => 'ca_biz_startup_post_readmore_toggle_switch_control',
        'type'     => 'checkbox',
    ) ) );

  

}
add_action( 'customize_register', 'ca_biz_startup_customize_register' );




