<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package buzzpress
 */

?>

<div id="post-<?php the_ID();?>" <?php post_class('mb-5 home-blog'); ?>>
	
		<div class="caption">
			<header class="entry-header list">
				<?php if ( 'post' === get_post_type() ) :?>
				<?php if(has_post_thumbnail()):?>
				<?php 
				buzzpress_post_thumbnail('buzzpress-blog-thumbnail'); 
				else:?>
				<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/no-thumb.png">
				<?php 
				endif;
				?>
				<?php endif; ?>

			</header><!-- .entry-header -->
		</div>
	
		<?php
		if ( is_singular() ) :
			the_title( '<h1 class="entry-title mb-3 mt-4">', '</h1>' );
		else :
			the_title( '<h1 class="entry-title mb-3 mt-4"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h1>' );
		endif;?>
		<div class="blog_post_meta mb-2 mt-2">
			<?php
				buzzpress_posted_by();
				buzzpress_get_category();
				buzzpress_posted_on();
				buzzpress_reading_time();
			?>
		</div>
		<div class="entry-content">
			<?php echo buzzpress_get_excerpt(325);?>
		</div><!-- .entry-content -->
</div>

