<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package buzzpress
 */

get_header();
?>
<main id="site-content" class="site-main container mt-5">
    <div id="primary" class="content-area">
        <div class="row">
			<?php
				if(get_theme_mod('sidebar')==false){
				  get_sidebar();
				}
			?>
            <div class="col-md-9 pr-3 pl-3">
                <?php
				while ( have_posts() ) :
					the_post();

					get_template_part( 'template-parts/content', get_post_type() );

				if ( is_singular( 'post' ) ) {
					// Previous/next post navigation.
					the_post_navigation(
						array(
							'next_text' => '<span class="next-post">' . __( 'Next post:', 'buzzpress' ) . '</span> ' .
								'<span class="post-title">%title</span>',
							'prev_text' => '<span class="previous-post">' . __( 'Previous post:', 'buzzpress' ) . '</span> ' .
								'<span class="post-title">%title</span>',
						)
					);
				}
				?>
				
				<section class="authorpage">
					<?php do_action( 'buzzpress_author' ); ?>
				</section>
				
				<?php // If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;
				?>
	
				<?php 
				endwhile; // End of the loop.
				?>
            </div>
            <!--/col-md-8-->
            <?php
				if(get_theme_mod('sidebar')==true){
				  get_sidebar();
				}
			?>
        </div>
		
        <!--/Row-->     
    </div><!-- #primary -->
</main><!-- #main -->

<?php
get_footer();