<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package buzzpress
 */

get_header();
?>

<?php 
/**
 * Hook - buzzpress_post_slider_action
 *
 * @hooked buzzpress_post_slider - 10
 */
do_action('buzzpress_post_slider_action');
?>

<main id="site-content" class="site-main container mt-6">
    <div id="primary" class="content-area">
	<div class="conatiner">
        <div class="row">
			<?php
				if(get_theme_mod('sidebar')==false){
				  get_sidebar();
				}
			?>
            <div class="col-md-9 pr-3 pl-3 bp-order-1">
                <?php
					if ( have_posts() ) :

						if ( is_home() && ! is_front_page() ) :
				?>
                <header>
                    <h1 class="page-title screen-reader-text entry-title mb-3">
						<?php single_post_title(); ?>
					</h1>
                </header>
                <?php
					endif;
					/* Start the Loop */
					while ( have_posts() ) :
						the_post();

						/*
						 * Include the Post-Type-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
						 */
						get_template_part( 'template-parts/content', 'archive');
						
					endwhile;

					if(function_exists('buzzpress_the_posts_pagination')):
						buzzpress_the_posts_pagination();
					endif;

				else :

					get_template_part( 'template-parts/content', 'none' );

				endif;
			?>
            </div>
			<?php
				if(get_theme_mod('sidebar')== true){
				  get_sidebar();
				}
			?>
        </div>

    </div><!-- #primary -->
</main><!-- #main -->

<?php
get_footer();