<?php 
/**
 * Custom theme functions.
 *
 * This file contains hook functions attached to theme hooks.
 *
 * @package BuzzPress
 */
if ( ! function_exists( 'buzzpress_header' ) ) :
	function buzzpress_header(){?>

<header class="nav-header">
	<!--Navbar -->
	<nav class="navbar navbar-expand-lg">
		<div class="container">
			<div class="site-info">
				<div class="dark-logo">
					<?php if(get_theme_mod('buzzpress_dark_logo')): ?>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<img src="<?php echo esc_url(get_theme_mod('buzzpress_dark_logo')); ?>" alt="<?php echo esc_attr(get_bloginfo( 'name' )); ?>" />
						</a>
					<?php else:?>
					<h1>
						<?php echo esc_html(get_bloginfo( 'name' )); ?>
					</h1>
				   <?php endif; ?>
				</div>
				<div class="light-logo">
					<?php buzzpress_site_logo();?>
				</div>
				<?php buzzpress_site_description();?>
			</div>
			 <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbar-collapse"
				aria-controls="navbar-collapse" aria-expanded="false"
				aria-label="<?php esc_attr_e( 'Toggle navigation', 'buzzpress' ); ?>">
				<span class="toggle-menu fa fa-bars"></span>
			</button>
			<?php
			if ( has_nav_menu( 'primary' ) ) :
				wp_nav_menu( array(
					'theme_location'    => 'primary',
					'depth'             => 3,
					'container'         => 'div',
					'container_class'   => 'collapse navbar-collapse justify-content-center',
					'container_id'      => 'navbar-collapse',
					'menu_class'        => 'nav navbar-nav',
					'items_wrap'		=> '<ul class="nav navbar-nav" data-function="navbar">%3$s</ul>',
				) );
			else:
			wp_page_menu(
				array(
					'container'  => 'div',
					'menu_id'    => 'navbar-collapse',
					'menu_class' => 'nav navbar-nav',
					'menu_class' => 'collapse navbar-collapse justify-content-center',
					'before'     => '<ul class="nav navbar-nav" data-function="navbar">',
					'after'      => '</ul>',
				)
			); 
		 endif; 
		 ?>
		</div>
	</nav>
</header>
<?php
	}
endif;
add_action('buzzpress_header','buzzpress_header', 10);

/**
Footer hook function
**/
if ( ! function_exists( 'buzzpress_footer' ) ) :
	function buzzpress_footer(){?>
<!--Footer-->
<footer class="footer sec-bg">
    <div class="container">
        <div class="row text-left mt-4 mb-4">
		<?php
			if (is_active_sidebar('footer_menu')) {
				dynamic_sidebar('footer_menu');
			}
		?>
        </div>
        <hr>
        <div class="row copyright_info">
            <div class="col-md-12">
                <div class="mt-2">
				<?php do_action('buzzpress_social');?>
                    <?php
					if (!is_active_sidebar('copyright')) {
					?>
                    <div class="footer-credits">
                        <p class="footer-copyright powered-by-wordpress">
                            &copy;
                            <?php
							echo date_i18n(
								/* translators: Copyright date format, see https://secure.php.net/date */
								_x( 'Y', 'copyright date format', 'buzzpress' )
							);
							?>
									
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?>.</a>
							<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'buzzpress' ) ); ?>">
							<?php _e( 'Powered by WordPress', 'buzzpress' ); ?>
							</a>
                        </p><!-- .powered-by-wordpress -->
                    </div><!-- .footer-credits -->
					
                    <?php } else{?>
                    <small><?php dynamic_sidebar('copyright');?> </small>
                    <?php }?>
                </div>
            </div>
        </div>
    </div>
</footer>
<?php
	}
endif;
add_action('buzzpress_footer','buzzpress_footer', 10);

/** 
	Post Slide 
**/
if ( ! function_exists( 'buzzpress_post_slider' ) ) :
function buzzpress_post_slider(){

 if(has_post_thumbnail()):
?>
	<div class="slide-grid">
		<div class="blog-slider">
			<?php
            global $post;
			$args = array(
				'category'       	=> get_theme_mod('select_cat'),
				'posts_per_page' 	=> get_theme_mod('slider_blog_number'),
				'orderby'          	=> get_theme_mod('order_by_setting'),
				'order'            	=> get_theme_mod('order_setting'),
			);
			$query = get_posts($args);
				foreach ( $query as $post ) :// phpcs:ignore WordPress.WP.GlobalVariablesOverride
				 ?>
				<figure class="effect-steve">
					 <?php 
						buzzpress_post_thumbnail();
					 ?>
					<div class="slide-wrapper">
					  <div class="slide-text">
						<div class="cat">
							<?php buzzpress_get_category();?>
						</div>
						<div class="slide-heading">
							<?php the_title( '<h2 class="slider-post-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );?>
						</div>
						  <div class="slide-body">
							<?php echo buzzpress_get_excerpt(90); ?>
						  </div>
						</div>
					</div>
				</figure>
				<?php
			endforeach; 
			wp_reset_postdata();
			?>
		</div>
		<button class="slick-nav slick-prev slick-arrow">
		<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="15.983px" height="11.837px" viewBox="0 0 15.983 11.837" enable-background="new 0 0 15.983 11.837" xml:space="preserve"><path class="thb-arrow-head" d="M1.486,5.924l4.845-4.865c0.24-0.243,0.24-0.634,0-0.876c-0.242-0.243-0.634-0.243-0.874,0L0.18,5.481
	c-0.24,0.242-0.24,0.634,0,0.876l5.278,5.299c0.24,0.241,0.632,0.241,0.874,0c0.24-0.241,0.24-0.634,0-0.876L1.486,5.924z"></path><path class="pp-arrow-line" d="M15.982,5.92c0,0.328-0.264,0.593-0.592,0.593H0.592C0.264,6.513,0,6.248,0,5.92c0-0.327,0.264-0.591,0.592-0.591h14.799
	C15.719,5.329,15.982,5.593,15.982,5.92z"></path></svg>
		</button>
		<button class="slick-nav slick-next slick-arrow">
			<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="15.983px" height="11.837px" viewBox="0 0 15.983 11.837" enable-background="new 0 0 15.983 11.837" xml:space="preserve"><path class="thb-arrow-head" d="M9.651,10.781c-0.24,0.242-0.24,0.635,0,0.876c0.242,0.241,0.634,0.241,0.874,0l5.278-5.299c0.24-0.242,0.24-0.634,0-0.876
l-5.278-5.299c-0.24-0.243-0.632-0.243-0.874,0c-0.24,0.242-0.24,0.634,0,0.876l4.845,4.865L9.651,10.781z"></path><path class="pp-arrow-line" d="M0.591,5.329h14.799c0.328,0,0.592,0.265,0.592,0.591c0,0.328-0.264,0.593-0.592,0.593H0.591C0.264,6.513,0,6.248,0,5.92
C0,5.593,0.264,5.329,0.591,5.329z"></path></svg>
		</button>
	</div>
<?php
endif;
}
endif;
/** 
	Post Slide Hooked
**/
add_action('buzzpress_post_slider_action','buzzpress_post_slider', 10);

// Author Box.
if ( ! function_exists( 'buzzpress_author' ) ) :
function buzzpress_author( $id ) {
	$id = $id ? $id : get_the_author_meta( 'ID' );
	?>
	<div class="row author-content">
		<div class="col-md-2">
			<?php echo get_avatar( $id, '130', '', '', array( 'class' => 'lazy-load' ) ); ?>
		</div>
		<div class="col-md-10">
			<h4 class="mb-2">
				<a href="<?php echo get_author_posts_url( $id ); ?>">
				<?php the_author_meta( 'display_name', $id ); ?>
				</a>
			</h4>
			<p>
			<?php the_author_meta( 'description', $id ); ?>
			</p>
			<?php if ( get_the_author_meta( 'url', $id ) !== '' ) { ?>
				<a href="<?php echo get_the_author_meta( 'url', $id ); ?>" target="_blank"><i class="fa fa-link"></i></a>
			<?php } ?>
		</div>
	</div>
	<?php if ( is_author() ):?>
		<div class="clearfix"></div>
		<h5 class="mt-5"><?php _e('Posts by','buzzpress')?> 
			<?php the_author_meta( 'display_name', $id ); ?>:
		</h5>
		<hr>
	<?php
	endif;
}
endif;
add_action( 'buzzpress_author', 'buzzpress_author', 3 );

/*==================== 
	BuzzPress Social 
=====================*/
function buzzpress_social(){
	$facebook	= get_theme_mod('facebook');
	$twitter	= get_theme_mod('twitter');
	$linkedin	= get_theme_mod('linkedin');
	$pinterest	= get_theme_mod('pinterest');
	$instagram	= get_theme_mod('instagram');
	
	if($facebook || $twitter || $linkedin || $pinterest || $instagram ):
?>
	<div class="social-network-wrap">
		<ul class="social-network">
			<?php if($facebook): ?>
				<li>
					<a href="<?php echo esc_url($facebook); ?>">
						<i class="fa fa-facebook"></i>
					</a>
				</li>
			<?php endif; ?>
			<?php if($twitter): ?>
				<li>
					<a href="<?php echo esc_url($twitter); ?>">
						<i class="fa fa-twitter"></i>
					</a>
				</li>
			<?php endif; ?>
			<?php if($linkedin): ?>
				<li>
					<a href="<?php echo esc_url($linkedin); ?>">
						<i class="fa fa-linkedin"></i>
					</a>
				</li>
			<?php endif; ?>
			<?php if($pinterest): ?>
				<li>
					<a href="<?php echo esc_url($pinterest); ?>">
						<i class="fa fa-pinterest"></i>
					</a>
				</li>
			<?php endif; ?>
			<?php if($instagram): ?>
				<li>
					<a href="<?php echo esc_url($instagram); ?>">
						<i class="fa fa-instagram"></i>
					</a>
				</li>
			<?php endif; ?>
		</ul>
	</div>
	<?php endif;?>
<?php }
add_action('buzzpress_social', 'buzzpress_social', 10);