<?php

function buzzpress_sidebar_sections( $wp_customize ) {
	
	/**
	 * Add sections
	 */
	$wp_customize->add_section( 'sidebar', array(
 		'title'       => __( 'Sidebar', 'buzzpress' ),
 		'priority'    => 12,
 		'panel'       => 'buzzpress_customizer',
 	) );
}
add_action( 'customize_register', 'buzzpress_sidebar_sections' );

function buzzpress_sidebar_fields( $fields ) {

    $fields[] = array(
		'type'        => 'switch',
		'settings'    => 'sidebar',
		'label'       => esc_html__( 'Switch your sidebar', 'buzzpress' ),
		'section'     => 'sidebar',
		'default'     => '0',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Right', 'buzzpress' ),
			'off' => esc_html__( 'Left', 'buzzpress' ),
	],
);
	
  return $fields;

}
add_filter( 'kirki/fields', 'buzzpress_sidebar_fields' );

?>