<?php
/**
 * buzzpress Theme Customizer
 *
 * @package buzzpress
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function buzzpress_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'buzzpress_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'buzzpress_customize_partial_blogdescription',
		) );
	}

 	// Sanitize text
	function buzzpress_sanitize_text( $text ) {
	    return sanitize_text_field( $text );
	}

	function buzzpress_sanitize_float( $input ) {
		return filter_var($input, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
	}

}
add_action( 'customize_register', 'buzzpress_customize_register' );


/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function buzzpress_customize_partial_blogname() {
	bloginfo( 'name' );
}


/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function buzzpress_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

function buzzpress_dark_logo_fields( $fields ) {
	
	$fields[] = array(
		'type'        => 'image',
		'settings'    => 'buzzpress_dark_logo',
		'label'       => esc_html__( 'Dark Logo', 'buzzpress' ),
		'section'     => 'title_tagline',
		'default'     => '',
	);
	
  return $fields;

}
add_filter( 'kirki/fields', 'buzzpress_dark_logo_fields' );
/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function buzzpress_customize_preview_js() {
	wp_enqueue_script( 'buzzpress-customizer', get_template_directory_uri() . '/assets/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'buzzpress_customize_preview_js' );