<?php

function buzzpress_customizer_sections( $wp_customize ) {

	/**
	 * Add sections
	 */
     $wp_customize->add_section( 'header_background', array(
 		'title'       => __( 'Social Settings', 'buzzpress' ),
 		'priority'    => 14,
 		'panel'       => 'buzzpress_customizer',
 	) ); 

}
add_action( 'customize_register', 'buzzpress_customizer_sections' );

function buzzpress_customizer_fields( $fields ) {

   $fields[] = array(
        'type'        => 'url',
        'settings'    => 'facebook',
        'label'       => __( 'Facebook URL', 'buzzpress' ),
        'section'     => 'header_background',
        'priority'    => 10,
    ); 
	$fields[] = array(
        'type'        => 'url',
        'settings'    => 'twitter',
        'label'       => __( 'Twitter', 'buzzpress' ),
        'section'     => 'header_background',
        'priority'    => 10,
    );
	$fields[] = array(
        'type'        => 'url',
        'settings'    => 'linkedin',
        'label'       => __( 'Linkedin', 'buzzpress' ),
        'section'     => 'header_background',
        'priority'    => 10,
    );
	$fields[] = array(
        'type'        => 'url',
        'settings'    => 'pinterest',
        'label'       => __( 'Pinterest', 'buzzpress' ),
        'section'     => 'header_background',
        'priority'    => 10,
    ); 
	$fields[] = array(
        'type'        => 'url',
        'settings'    => 'instagram',
        'label'       => __( 'Instagram', 'buzzpress' ),
        'section'     => 'header_background',
        'priority'    => 10,
    ); 

	$fields[] = array(
        'type'        => 'color',
        'settings'    => 'social_color',
        'label'       => __( 'Social Color', 'buzzpress' ),
        'section'     => 'header_background',
        'priority'    => 11,
		'default'     => '#888',
		'transport'   => 'postMessage',
		'output' => array(
				array(
					'element'  => '.social-network .fa',
					'property' => 'color',
				),
		),
    );
	$fields[] = array(
        'type'        => 'dimension',
		'settings'    => 'social_font_size',
		'label'       => esc_html__( 'Font Size', 'buzzpress' ),
		'description' => esc_html__( 'Use any font size with size and unit (eg. 36px).', 'buzzpress' ),
		'section'     => 'header_background',
		'transport'   => 'postMessage',
		'default'     => '36px',
		'output' => array(
				array(
					'element'  => '.social-network .fa',
					'property' => 'font-size',
				),
		),
    );
	
    return $fields;

}
add_filter( 'kirki/fields', 'buzzpress_customizer_fields' );

?>