<?php

function buzzpress_color_customizer_sections( $wp_customize ) {
	
	/**
	 * Add sections
	 */
     $wp_customize->add_section( 'color_customizer', array(
 		'title'       => __( 'Color Settings', 'buzzpress' ),
 		'priority'    => 10,
 		'panel'       => 'buzzpress_customizer',
 	) );

    

}
add_action( 'customize_register', 'buzzpress_color_customizer_sections' );

function buzzpress_color_customizer_fields( $fields ) {
	$fields[] = array(
			'type'        => 'switch',
			'settings'    => 'buzzpress_color',
			'label'       => esc_html__( 'Switch to dark mode', 'buzzpress' ),
			'section'     => 'color_customizer',
			'default'     => '1',
			'priority'    => 10,
			'choices'     => [
				'on'  => esc_html__( 'Light', 'buzzpress' ),
				'off' => esc_html__( 'Dark', 'buzzpress' ),
		],
	);
    return $fields;
}
add_filter( 'kirki/fields', 'buzzpress_color_customizer_fields' );



add_action( 'wp_head', 'buzzpress_customize_css' );
function buzzpress_customize_css() {
?>
<style type="text/css">
:root{
	--color-bg:#222831;
	--heading-color:#fff;
	--text-color:#ececec;
}
</style>
<?php
}

?>