<?php

function buzzpress_slider_customizer_sections( $wp_customize ) {
	/**
	 * Add panels
	 */
	$wp_customize->add_panel( 'buzzpress_customizer', array(
		'priority'    => 12,
		'title'       => __( 'BuzzPress Options', 'buzzpress' ),
	) );

	/**
	 * Add sections
	 */
     $wp_customize->add_section( 'blog_customizer', array(
 		'title'       => __( 'Slider Settings', 'buzzpress' ),
 		'priority'    => 11,
 		'panel'       => 'buzzpress_customizer',
 	) );

}
add_action( 'customize_register', 'buzzpress_slider_customizer_sections' );

function buzzpress_blog_customizer_fields( $fields ) {
	$fields[] = array(
		'type'        => 'select',
		'settings'    => 'select_cat',
		'label'       => __( 'Slider Category', 'buzzpress' ),
		'description' => __( 'Select your category', 'buzzpress' ),
		'section'     => 'blog_customizer',
		'multiple'    => 999,
		'default'     => 0,
		'priority'    => 11,
		'choices'     => Kirki_Helper::get_terms( 'category' ),
    );
	
   $fields[] = array(
		'type'        => 'number',
		'settings'    => 'slider_blog_number',
		'label'       => esc_html__( 'Slider to show', 'buzzpress' ),
		'section'     => 'blog_customizer',
		'default'     => 5,
		'choices'     => [
			'min'  => 0,
			'max'  => 20,
			'step' => 1,
		],
    ); 
	$fields[] = array(
		'type'        => 'select',
		'settings'    => 'order_setting',
		'label'       => esc_html__( 'Order', 'buzzpress' ),
		'section'     => 'blog_customizer',
		'default'     => 'DESC',
		'placeholder' => esc_html__( 'Select an option...', 'buzzpress' ),
		'priority'    => 10,
		'multiple'    => 1,
		'choices'     => [
			'DESC' => esc_html__( 'DESC', 'buzzpress' ),
			'ASC' => esc_html__( 'ASC', 'buzzpress' ),
		],
    );
	$fields[] = array(
		'type'        => 'select',
		'settings'    => 'order_by_setting',
		'label'       => esc_html__( 'Order by', 'buzzpress' ),
		'section'     => 'blog_customizer',
		'default'     => 'date',
		'placeholder' => esc_html__( 'Select an option...', 'buzzpress' ),
		'priority'    => 10,
		'multiple'    => 1,
		'choices'     => [
			'date' => esc_html__( 'date', 'buzzpress' ),
			'ID' => esc_html__( 'ID', 'buzzpress' ),
			'author' => esc_html__( 'author', 'buzzpress' ),
			'title' => esc_html__( 'title', 'buzzpress' ),
			'name' => esc_html__( 'name', 'buzzpress' ),
			'rand' => esc_html__( 'rand', 'buzzpress' ),
		],
    );
	 $fields[] = array(
        'type'        => 'color',
        'settings'    => 'buzzpress_slide_color',
        'label'       => __( 'Slider Background', 'buzzpress' ),
        'section'     => 'blog_customizer',
        'priority'    => 10,
		'transport'   => 'refresh',
		'default' 	  =>'#d2071a',
		'output' => array(
				array(
					'element'  => '.slick-nav, .blog-slider figure:hover .slide-wrapper .slide-text',
					'property' => 'background',
				),
		),
    );
	
    return $fields;
}
add_filter( 'kirki/fields', 'buzzpress_blog_customizer_fields' );

?>