<?php
/**
 * The template for displaying author pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package buzzpress
 */

get_header();
?>
<main id="site-content" class="site-main container mt-5">
	<div id="primary" class="content-area">
		<div class="row">
			<?php
				if(get_theme_mod('sidebar')===false){
				  get_sidebar();
				}
			?>
			<div class="col-md-8">
				<section class="authorpage">
					<?php 
					if ( is_author() ):
						$author = get_user_by( 'slug', get_query_var( 'author_name' ) );
						do_action( 'buzzpress_author', $author->ID );
					endif; 
					?>
				</section>
				<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
				<?php get_template_part( 'template-parts/content', 'archive');?>
				<?php endwhile; 
				// Previous/next page navigation.
				the_posts_pagination();
				else: ?>
				<p><?php _e('No posts by this author.','buzzpress'); ?></p>
				<?php endif; ?> 
			</div>
			<?php
				if(get_theme_mod('sidebar')==true){
				  get_sidebar();
				}
			?>
		</div>
	</div><!-- #primary -->
</main><!-- #main -->

<?php
get_footer();