<?php

add_action( 'customize_register', 'buswick_customizer_theme_info' );

function buswick_customizer_theme_info( $wp_customize ) {
	
    $wp_customize->add_section( 'buswick_theme_info_section' , array(
		'title'       => esc_html__( '❂ Theme Info' , 'buswick' ),
		'priority' => 2
	) );
    

	$wp_customize->add_setting( 'theme_info', array(
		'default' => '',
		'sanitize_callback' => 'wp_kses_post',
	) );
    
    $theme_info = '';
	
	$theme_info .= '<span class="sticky_info_row wp-clearfix"><label class="row-element">' . esc_html__( 'Theme Details', 'buswick' ) . ': </label><a class="button alignright" href="' . esc_url( 'https://graphthemes.com/buswick/' ) . '" target="_blank">' . esc_html__( 'Click Here', 'buswick' ) . '</a></span><hr>';

	$theme_info .= '<span class="sticky_info_row wp-clearfix"><label class="row-element">' . esc_html__( 'How to use', 'buswick' ) . ': </label><a class="button alignright" href="' . esc_url( 'https://graphthemes.com/theme-docs/buswick/' ) . '" target="_blank">' . esc_html__( 'Click Here', 'buswick' ) . '</a></span><hr>';
	$theme_info .= '<span class="sticky_info_row wp-clearfix"><label class="row-element">' . esc_html__( 'View Demo', 'buswick' ) . ': </label><a class="button alignright" href="' . esc_url( 'https://graphthemes.com/preview/?product_id=buswick' ) . '" target="_blank">' . esc_html__( 'Click Here', 'buswick' ) . '</a></span><hr>';
	$theme_info .= '<span class="sticky_info_row wp-clearfix"><label class="row-element">' . esc_html__( 'Support Forum', 'buswick' ) . ': </label><a class="button alignright" href="' . esc_url( 'https://wordpress.org/support/theme/buswick' ) . '" target="_blank">' . esc_html__( 'Click Here', 'buswick' ) . '</a></span><hr>';

	$wp_customize->add_control( new Buswick_Custom_Text( $wp_customize ,'theme_info',array(
		'section' => 'buswick_theme_info_section',
		'label' => $theme_info
	) ) );

}