<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @package businessup
 */

get_header(); ?>
<!--==================== ti breadcrumb section ====================-->
<?php get_template_part('index','banner'); ?>
<!--==================== main content section ====================-->
<main id="content" class="index-class">
  <div class="container">
    <div class="row">
      <?php $businessup_content_layout = get_theme_mod('businessup_content_layout','align-content-right');
      if($businessup_content_layout == 'align-content-left'){ ?>
        <aside class="col-md-3">
          <?php get_sidebar(); ?>
        </aside>
      <?php } 
      if(($businessup_content_layout == 'align-content-left') || ($businessup_content_layout == 'align-content-right')){ ?>
        <div class="col-md-9">
      <?php } else { ?>
        <div class="col-md-12">
      <?php }
			  while(have_posts()){ the_post();
			  ?>
			  <?php get_template_part('content',''); ?> 
			  <?php } ?>
			
		<div class="col-md-12 text-center">
			<?php
			//Previous / next page navigation
			the_posts_pagination( array(
			'prev_text'          => '<i class="fas fa-long-arrow-alt-left"></i>',
			'next_text'          => '<i class="fas fa-long-arrow-alt-right"></i>',
			'screen_reader_text' => ' ',
			) );
			?>
        </div>
      </div>
      <?php if($businessup_content_layout == 'align-content-right'){ ?>
        <aside class="col-md-3">
          <?php get_sidebar(); ?>
        </aside>
      <?php } ?>
    </div>
  </div>
 </main>
<?php
get_footer();
?>