<?php
function businessup_general_setting( $wp_customize ) { 
    /* General Section */
    $wp_customize->add_panel( 'general_options', array(
        'priority' => 10,
        'capability' => 'edit_theme_options',
        'title' => __('General Settings', 'businessup'),
    ) ); 
    

    //Scroller settings
    $wp_customize->add_section(
        'scroller',
        array(
            'priority'      => 1,
            'title'         => __('Scroller','businessup'),
            'panel'         => 'general_options',
        )
    );


    //Enable and disable social icon
    $wp_customize->add_setting(
    'scroller_enable'
    ,
    array(
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'businessup_header_sanitize_checkbox',
    )   
    );
    $wp_customize->add_control(
    'scroller_enable',
		array(
			'label' => __('Hide / Show','businessup'),
			'section' => 'scroller',
			'type' => 'checkbox',
		)
    );
    
    $wp_customize->add_setting( 
    'breadcrumb_img_type_display' , 
        array(
            'default' => 'scroll',
            'capability'     => 'edit_theme_options',
            'sanitize_callback' => 'businessup_sanitize_select',
            'priority'  => 1,
        ) 
    );
    
    $wp_customize->add_control(
    'breadcrumb_img_type_display' , 
        array(
            'label'          => __( 'Background Attachment', 'businessup' ),
            'section'        => 'header_image',
            'type'           => 'select',
            'choices'        => 
            array(
                'scroll' => __( 'Scroll', 'businessup' ),
                'fixed'   => __( 'Fixed', 'businessup' )
            ) 
        ) 
    );
    
    $wp_customize->add_setting(
        'header_img_bg_color', array( 'sanitize_callback' => 'sanitize_text_field',
        'default' =>'',
    ) );
    
    $wp_customize->add_control(new businessup_Customize_Alpha_Color_Control( $wp_customize,
        'header_img_bg_color', array(
        'label'      => __('Overlay Color', 'businessup' ),
        'palette' => true,
        'section' => 'header_image')
    ) );

}
add_action( 'customize_register', 'businessup_general_setting' );



function businessup_general_sanitize_checkbox( $input ) {
            // Boolean check 
    return ( ( isset( $input ) && true == $input ) ? true : false );
    
    }
add_action( 'customize_register', 'businessup_general_sanitize_checkbox' );


function businessup_sanitize_select( $input, $setting ) {
    
    // Ensure input is a slug.
    $input = sanitize_key( $input );
    
    // Get list of choices from the control associated with the setting.
    $choices = $setting->manager->get_control( $setting->id )->choices;
    
    // If the input is a valid key, return it; otherwise, return the default.
    return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
}