<?php
/**
 * The template for displaying the content.
 * @package businessup
 */
?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="businessup-blog-post-box"> 
		<?php
		$post_thumbnail_url = get_the_post_thumbnail( get_the_ID(), 'img-fluid' );
		if ( !empty( $post_thumbnail_url ) ) {
		?>
		<a href="<?php esc_attr(the_permalink()); ?>" title="<?php the_title_attribute(); ?>" class="businessup-blog-thumb">
			<?php echo $post_thumbnail_url; ?>
        </a>
		<?php
		}
		?>
		<article class="small"> 
			<?php $post_category = get_theme_mod('post_category_enable',false);
			$post_title = get_theme_mod('post_title_enable',false);
			$post_meta = get_theme_mod('post_meta_enable',false);
			if($post_title !== true) { ?>
			<h4 class="title"><a href="<?php esc_attr(the_permalink()); ?>" title="<?php the_title_attribute(); ?>"> <?php the_title(); ?> </a> </h4>
			<?php } if(($post_category !== true) || ($post_meta !== true)) { ?>
				<div class="businessup-blog-category"> 
					<?php if($post_meta !== true){ ?>	
					<span class="businessup-blog-date">
						<a href="<?php echo esc_url(get_month_link(esc_html(get_post_time('Y')),esc_html(get_post_time('m')))); ?>">
							<?php echo esc_html(get_the_date()); ?>
						</a>
					</span> 
					<?php } if($post_category !== true) { ?>
					<span class="cat-links">
						<?php   $cat_list = get_the_category_list();
						if(!empty($cat_list)) { 
							the_category(', '); 
						} ?>
					</span>	
					<?php } if($post_meta !== true){ ?>
						<a class="businessup-author" href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ) ));?>"><?php esc_html_e('by','businessup'); ?>
							<?php the_author(); ?>
						</a> 
						<?php businessup_edit_link();
					} ?>
					</div>
			<?php }
				$businessup_more = strpos( $post->post_content, '<!--more' );
				if ( $businessup_more ) :
					echo get_the_content();
				else :
					echo get_the_excerpt();
				endif;
			?>
			
				<?php wp_link_pages( array( 'before' => '<div class="link">' . __( 'Pages:', 'businessup' ), 'after' => '</div>' ) ); ?>
		</article>
	</div>
</div>