<?php
/**
 * The template for displaying archive pages.
 *
 * @package businessup
 */
get_header();
$header_img_bg_color = get_theme_mod('header_img_bg_color'); 
$breadcrumb_img_type_display = get_theme_mod('breadcrumb_img_type_display','scroll');
?>
<!-- Breadcrumb -->
<div class="businessup-breadcrumb-section" style='background: url("<?php echo( has_header_image() ? get_header_image() : get_theme_support( 'custom-header', 'default-image' ) ); ?>") ;background-attachment: <?php echo esc_attr($breadcrumb_img_type_display); ?>;'>
<div class="overlay" style="background-color: <?php echo $header_img_bg_color ?>">
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <div class="businessup-breadcrumb-title">
            <?php
					the_archive_title( '<h1 class="page-title">', '</h1>' );
					the_archive_description( '<div class="taxonomy-description">', '</div>' );
			?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- /End Breadcrumb -->
<main id="content" class="archive-class">
  <div class="container">
    <div class="row">
      <?php $businessup_content_layout = get_theme_mod('businessup_content_layout','align-content-right');
      if($businessup_content_layout == 'align-content-left'){ ?>
        <aside class="col-md-3">
          <?php get_sidebar(); ?>
        </aside>
      <?php } 
      if(($businessup_content_layout == 'align-content-left') || ($businessup_content_layout == 'align-content-right')){ ?>
        <div class="col-md-9">
      <?php } else { ?>
        <div class="col-md-12">
      <?php }
    		  while(have_posts()){ the_post();
              get_template_part('content','');
    		  } ?>
          <div class="text-center">
      			<?php //Previous / next page navigation
      			the_posts_pagination( array(
      			'prev_text'          => '<i class="fa fa-angle-left"></i>',
      			'next_text'          => '<i class="fa fa-angle-right"></i>',
      			) ); ?>
          </div>
      </div>
      <?php if($businessup_content_layout == 'align-content-right'){ ?>
        <aside class="col-md-3">
          <?php get_sidebar(); ?>
        </aside>
      <?php } ?>
    </div>
  </div>
</main>
<?php get_footer(); ?>