<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Business_Process
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'news-content' ); ?>>
	<div class="news-wrap">
		<?php if( has_post_thumbnail( ) ):  ?>
			<div class="news-img-wrap">
				<figure>
					<?php the_post_thumbnail( 'business-prcoess-blog' ); ?>
				</figure>
				<div class="hover-icon">
					<a href="<?php the_permalink()?>"> <i class="fa fa-link"></i> </a>
				</div>
			</div>
		<?php endif; ?>
		<div class="news-caption">
			<div class="entry-meta">
				<?php business_process_categories_list();
				business_process_posted_on(); 
				?>
			</div>
			<header class="entry-header">
				<h5 class="entry-title"><a href="<?php the_permalink() ?>"><?php the_title();?></a></h5>
			</header>
			<div class="entry-content">
				<?php
					business_process_content_length();
                ?>
			</div>
			<?php $archive_button = business_process_get_option( 'archive_button');
			if ( !empty( $archive_button ) ): ?>
				<a href="<?php the_permalink() ?>" class="btn light-btn"><?php echo esc_html( $archive_button );?></a>
			<?php endif; ?>
		</div>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->
