<?php
/**
 * Template for Testimonial
 *
 * @package Business_Process
 */
?>
<?php $enable_testimonial 	= business_process_get_option( 'enable_testimonial' );
$testimonial_section_title	= business_process_get_option( 'testimonial_section_title' );
$testimonial_layout		= business_process_get_option( 'testimonial_layout' );
$testimonial_category = business_process_get_option( 'testimonial_category' );
$testimonial_number		= business_process_get_option( 'testimonial_number' );	
if ( true == $enable_testimonial ):
?>
	<section class="testimonial-section defult-padding ">
		<div class="container">		
			<?php $testimonial_args = array(
				'posts_per_page' => absint( $testimonial_number ),			
				'post_type' => 'post',
                'post_status' => 'publish',
                'paged' => 1,
			);

			if ( absint( $testimonial_category ) > 0 ) {
				$testimonial_args['cat'] = absint( $testimonial_category );
			}			
			// Fetch posts.
			$the_query = new WP_Query( $testimonial_args );						
			if ( $the_query->have_posts() ) : $count= 0;?>			
				<div class="testimonial-wrap">
					<div class="owl-carousel owl-theme testimonial-slider">
						<?php while ( $the_query->have_posts() ) : $the_query->the_post();  $count++;?>	
								<div class="item">
									<div class="testimonial-img wow fadeInUp">
										<figure>
											<?php the_post_thumbnail();?>
										</figure>								
									</div>
									<div class="testimonial-caption wow fadeInUp">
										<div class="testimonial-indro"><?php the_title();?></div>
										<div class="entry-content">
											<?php
					                          $excerpt = business_process_the_excerpt(20);
					                          echo wp_kses_post( wpautop( $excerpt ) );
					                        ?>
				                        </div>
									</div>
								</div>
						<?php endwhile;
						wp_reset_postdata();?>
					</div>
				</div>
			<?php endif; ?>
		</div>
	</section>

<?php endif; ?>