<?php
/**
 * Template for Service Section
 *
 * @package Business_Process
 */

$enable_service = business_process_get_option( 'enable_service' );
$service_category 	= business_process_get_option( 'service_category' );
$service_number		= business_process_get_option( 'service_number' );
$service_section_title		= business_process_get_option( 'service_section_title' );
if ( true == $enable_service ):
?>
	<section class="service-section defult-padding">
		<div class="container">
			<?php if ($service_section_title ): ?>
				<div class="heading wow slideInUp">
					<header class="entry-header">
						<h2 class="entry-title"><?php echo esc_html( $service_section_title );?></h2>
					</header>
				</div>
			<?php endif; ?>
			<?php $service_args = array(
				'post_type'   => 'post',
				'posts_per_page' => absint( $service_number ),
                'post_status' => 'publish',
                'paged' => 1,
			);
			if ( absint( $service_category ) > 0 ) {
				$service_args['cat'] = absint( $service_category );
			}			

			// Fetch posts.
			$the_query = new WP_Query( $service_args );						
			if ( $the_query->have_posts() ) : $count= 0;?>			
				<div class="row">
					<?php while ( $the_query->have_posts() ) : $the_query->the_post(); $count++;
					?>
						<div class="custom-col-4 service-caption wow fadeInUp" data-wow-duration="<?php echo absint( $count )?>s">
							<div class="icon-wrap">								
								<?php 
									the_post_thumbnail();
								?>
							</div>
							<header class="entry-header">
								<h5 class="entry-title">
									<a href="<?php the_permalink()?>#tabs-<?php echo absint( get_the_id() );?>"><?php the_title()?></a>
								</h5>
							</header>
							<div class="entry-content">
								<?php
		                          $excerpt = business_process_the_excerpt(30);
		                          echo wp_kses_post( wpautop( $excerpt ) );
		                        ?>
							</div>
						</div>
				<?php endwhile;
				wp_reset_postdata();?>
				</div>
			<?php endif; ?>
		</div>
	</section>

<?php endif; ?>