<?php
/**
 * Template for Contact
 *
 * @package Business_Process
 */
?>
<?php $enable_contact 	= business_process_get_option( 'enable_contact' );
$contact_section_title 	= business_process_get_option( 'contact_section_title' );
$contact_section_desc 	= business_process_get_option( 'contact_section_desc' );
$contact_section_form 	= business_process_get_option( 'contact_section_form' );
if ( true == $enable_contact ):
?>
	<section class="home-contact-section defult-padding">
		<?php $contact_image_upload = business_process_get_option( 'contact_image_upload' ); ?>
		<div class="container">
			<?php if ( !empty( $contact_image_upload ) ): ?>
				<figure>
					<img src="<?php echo esc_url( $contact_image_upload );?>" alt="support-img">
				</figure>	
			<?php endif; ?>		
			<div class="row">
				<div class="custom-col-4 contact-left wow slideInLeft">
					<div class="heading wow slideInUp">
						<?php if ( $contact_section_title ): ?>
							<header class="entry-header">
								<h2 class="entry-title"><?php echo esc_html( $contact_section_title );?></h2>
							</header>
						<?php endif; ?>
					</div>
					<p><?php echo esc_html( $contact_section_desc );?></p>
				</div>
				<?php if ( $contact_section_form ): ?>
					<div class="custom-col-8 home-contact-wrap wow slideInRight">
						<div class="contact-form-wrap">
						  	<?php $args = array (	            		            
						      	'page_id'			=> absint($contact_section_form ),
						    	'post_status'   	=> 'publish',
						    	'post_type' 		=> 'page',
						    );

						    $loop = new WP_Query($args); 

						    if ( $loop->have_posts() ) : ?>						
								<?php while ($loop->have_posts()) : $loop->the_post();?>
									<div class="entry-content">
										<?php the_content();?>
									</div>
								<?php endwhile;
								wp_reset_postdata();
							endif; ?>
						</div>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</section>

<?php endif; ?>