<?php
/**
 * Template for Blog
 *
 * @package Business_Process
 */
?>
<?php $enable_blog 	= business_process_get_option( 'enable_blog' );
$blog_section_title = business_process_get_option( 'blog_section_title' );
$blog_category 		= business_process_get_option( 'blog_category' );
$blog_number		= business_process_get_option( 'blog_number' );
$blog_layout		= business_process_get_option( 'blog_layout' );

if ( true == $enable_blog ):
?>
	<section class="latest-news-section defult-padding <?php echo esc_attr( $blog_layout);?>">
		<div class="container">
			<?php if ( $blog_section_title ): ?>
				<div class="heading wow slideInUp">
					<header class="entry-header">
						<h2 class="entry-title"><?php echo esc_html( $blog_section_title );?></h2>
					</header>
				</div>
			<?php endif; ?>
			<?php $blog_args = array(
				'posts_per_page' => absint( $blog_number ),			
				'post_type' => 'post',
                'post_status' => 'publish',
                'paged' => 1,
			);

			if ( absint( $blog_category ) > 0 ) {
				$blog_args['cat'] = absint( $blog_category );
			}			
			// Fetch posts.
			$the_query = new WP_Query( $blog_args );						
			if ( $the_query->have_posts() ) : $count= 0;?>				
				<div class="row news-wrapper">
					<?php while ( $the_query->have_posts() ) : $the_query->the_post();  $count++;?>
						<div class="custom-col-4 news-content wow fadeInUp" data-wow-duration="<?php echo absint( $count );?>">
							<div class="news-wrap">
								<div class="news-img-wrap">
									<figure>
										<?php the_post_thumbnail( 'business-prcoess-blog' );?>
										<?php if ( 'layout-2' == $blog_layout ): ?>
											<div class="entry-meta">
												<?php business_process_categories_list();
												business_process_posted_on(); 
												?>
											</div>
										<?php endif; ?>										
									</figure>
									<div class="hover-icon">
										<a href="<?php the_permalink();?>"> <i class="fa fa-link"></i> </a>
									</div>
								</div>
								<div class="news-caption">
									<?php if ( 'layout-1' == $blog_layout ): ?>
										<div class="entry-meta">
											<?php business_process_categories_list();
											business_process_posted_on(); 
											?>
										</div>
									<?php endif; ?>
									<header class="entry-header">
										<h5 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h5>
									</header>
								</div>
							</div>
						</div>
					<?php endwhile; 
					wp_reset_postdata();?>	
				</div>
			<?php endif; ?>
		</div>
	</section>
<?php endif; ?>