<?php
/**
 * Template for Company Intro Page 
 *
 * @package Business_Process
 */
?>
<?php
$about_title_array = array();
$about_page_array = array();
for ($i=1; $i < 4; $i++) { 
	$about_title 	= business_process_get_option( 'about_title_'.$i );
	$about_page 	= business_process_get_option( 'about_page_'.$i );
	if( !empty( $about_title ) ) {
		array_push( $about_title_array, $about_title );// Push the category id in the array
	}
	if( !empty( $about_title ) ) {
		array_push( $about_page_array, $about_page );// Push the category id in the array
	}	
} 
?>
<section class="company-info">
	<div class="container">
		<div id="tab-layout-2" class="HorizontalTab design2-tab">          
			<ul class="resp-tabs-list hor_1"">
				<?php foreach ($about_title_array as $about_value) { ?>
					<li><?php echo esc_html( $about_value ); ?></li>					
				<?php } ?>
			</ul> 

			<div class="resp-tabs-container hor_1"> 
			  	<?php $args_intro = array (       		            
			      	'posts_per_page' => 3,
			    	'post_status'   	=> 'publish',
			    	'post__in'       => $about_page_array,
			    	'orderby'        => 'post__in',
			    	'post_type' 		=> 'page',
			    );

			    $loop = new WP_Query( $args_intro ); 

			    if ( $loop->have_posts() ) : 
			    	while ($loop->have_posts()) : $loop->the_post();?>		
			    		<?php $no_image = 'custom-col-8';
			    		if ( ! has_post_thumbnail() ){
			    			$no_image = 'custom-col-12';
			    		}
			    		?>		
						<div class="tab-content-layout">
							<div class="row">								
								<?php if( has_post_thumbnail() ): ?>
									<div class="custom-col-4">
										<figure>
											<?php the_post_thumbnail();?>
										</figure>
									</div>
								<?php endif; ?>
								<div class="<?php echo esc_attr( $no_image );?> tab-content-detail">
									<header>
										<h5 class="entry-title"><?php the_title();?></h5>
									</header>
									<?php the_content();?>
								</div>
							</div>
						</div>
					<?php endwhile;
					wp_reset_postdata();
				endif; ?>
				
			</div>
		</div> 
	</div>
</section>