<?php
/**
 * Custom theme hooks
 *
 * @package Business_Process
 */

if ( ! function_exists( 'business_process_slider' ) ) :

	/**
	 * Add breadcrumb.
	 *
	 * @since 1.0.0
	 */
	function business_process_slider() {

		if ( is_front_page() && ! is_home() ) { ?>		
			<?php $enable_slider = business_process_get_option( 'enable_slider' );
			$slider_category 	= business_process_get_option( 'slider_category' );
			$slider_number		= business_process_get_option( 'slider_number' );
			$slider_button_title 	= business_process_get_option( 'slider_button_title' );
			$slider_button_url 		= business_process_get_option( 'slider_button_url' );
			if ( true == $enable_slider) : ?>
				<div class="feature-slider-wrapper">					 
					<?php $slider_args = array(
						'posts_per_page' => absint( $slider_number ),			
						'post_type' => 'post',
		                'post_status' => 'publish',
		                'paged' => 1,
					);

					if ( absint( $slider_category ) > 0 ) {
						$slider_args['cat'] = absint( $slider_category );
					}
					
					// Fetch posts.
					$the_query = new WP_Query( $slider_args );						
					?>

						<?php if ( $the_query->have_posts() ) : ?>
							<div class="owl-carousel owl-theme feature-slider" >
								<?php while ( $the_query->have_posts() ) : $the_query->the_post(); 
								$image_url = get_template_directory_uri() . '/assets/img/slider.jpg';		
								if( has_post_thumbnail() ){
									$image_url = wp_get_attachment_url( get_post_thumbnail_id() );
								} 								

								?>
									<div class="item" style="background-image: url( <?php echo esc_url( $image_url ); ?>);">
										<div class="caption text-right">
											<div class="container">
												<div class="caption-wrap">
													<header class="entry-header">
														<h2 class="entry-title">
															<a href="<?php the_permalink();?>">
																<?php the_title();?>		
															</a>
														</h2>
													</header>
													<div class="btn-wrap">
														<a href="<?php the_permalink();?>" class="btn light-btn"><?php echo esc_html__( 'Read More ', 'business-process');?></a>
														<?php if( !empty( $slider_button_title ) ): ?>
															<a href="<?php echo esc_url( $slider_button_url);?>" class="btn light-btn"><?php echo esc_html( $slider_button_title );?></a>
														<?php endif; ?>
													</div>
												</div>
											</div>
										</div>										
									</div>
								<?php endwhile;?>
								<?php wp_reset_postdata(); ?>
			           		</div>
		           		<?php endif;?>
				</div>
			<?php endif; ?>
		<?php }
	}

endif;

add_action( 'business_process_action_header', 'business_process_slider', 10 );


if ( ! function_exists( 'business_process_add_breadcrumb' ) ) :

	/**
	 * Add breadcrumb.
	 *
	 * @since 1.0.0
	 */
	function business_process_add_breadcrumb() {
		$breadcrumb_image = get_header_image(); 
		$enable_breadcrumb = business_process_get_option( 'enable_breadcrumb' );

		if ( false == $enable_breadcrumb ){
			return;
		}

		// Bail if Home Page.
		if ( is_front_page() || is_home() ) {
			return;
		} ?>
		<div class="page-title-wrap" style="background-image: url( <?php echo esc_url( $breadcrumb_image ); ?>);"><div class="container">
			<?php business_process_header_banner_title(); 
			business_process_breadcrumb(); ?>
		</div></div>
	<?php }

endif;

add_action( 'business_process_action_header', 'business_process_add_breadcrumb' );