<?php
/**
 * Load BASIC Function.
 *
 * @package Business_Process
 */

if ( ! function_exists( 'business_process_fonts_url' ) ) {
	/**
	 * Register Google fonts.
	 *
	 * @return string Google fonts URL for the theme.
	 */
	function business_process_fonts_url() {
		$fonts_url = '';
		$fonts     = array();
		$subsets   = 'latin,latin-ext';

		/* translators: If there are characters in your language that are not supported by Barlow, translate this to 'off'. Do not translate into your own language. */
		if ( 'off' !== _x( 'on', 'Open Sans: on or off', 'business-process' ) ) {
			$fonts[] = 'Open Sans:300,300i,400,400i,500,500i,600,600i,700,700i,800,800i';
		}
		/* translators: If there are characters in your language that are not supported by Playfair Display, translate this to 'off'. Do not translate into your own language. */
		if ( 'off' !== _x( 'on', 'Poppins: on or off', 'business-process' ) ) {
			$fonts[] = 'Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
		}

		if ( $fonts ) {
			$fonts_url = add_query_arg( array(
				'family' => urlencode( implode( '|', $fonts ) ),
				'subset' => urlencode( $subsets ),
			), '//fonts.googleapis.com/css' );
		}

		return $fonts_url;
	}
}

if ( ! function_exists( 'business_process_navigation' ) ) :

	/**
	 * Posts navigation.
	 *
	 * @since 1.0.0
	 */
function business_process_navigation() {

	$pagination_option = business_process_get_option('pagination_option');

	if ( 'default' == $pagination_option) {

		the_posts_navigation();	

	} else{

		the_posts_pagination( array(
			'mid_size' => 5,
			'prev_text' => esc_html__( 'PREV', 'business-process' ),
			'next_text' => esc_html__( 'NEXT', 'business-process' ),
			) );
	}

}
endif;

add_action( 'business_process_action_navigation', 'business_process_navigation' );