<?php
/**
 * Theme Options.
 *
 * @package Business_Process
 */

$default = business_process_get_default_theme_options();

/****************  Add Pannel   ***********************/
$wp_customize->add_panel( 'theme_option_panel',
	array(
	'title'      => esc_html__( 'Theme Options', 'business-process' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	)
);
/************************  Site Identity  ******************/
$wp_customize->add_setting('theme_options[site_identity]', 
	array(
	'default' 			=> $default['site_identity'],
	'sanitize_callback' => 'business_process_sanitize_select'
	)
);
$wp_customize->add_control('theme_options[site_identity]', 
	array(		
	'label' 	=> esc_html__('Choose Option', 'business-process'),
	'section' 	=> 'title_tagline',
	'settings'  => 'theme_options[site_identity]',
	'type' 		=> 'radio',
	'choices' 	=>  array(
			'logo-only' 	=> esc_html__('Logo Only', 'business-process'),
			'logo-title' 	=> esc_html__('Logo + Title', 'business-process'),
			'logo-text' 	=> esc_html__('Logo + Tagline', 'business-process'),
			'title-only' 	=> esc_html__('Title Only', 'business-process'),
			'title-text' 	=> esc_html__('Title + Tagline', 'business-process')
		)
	)
);

/****************  Header Setting Section starts ************/
$wp_customize->add_section('section_header', 
	array(    
	'title'       => esc_html__('Header Setting', 'business-process'),
	'panel'       => 'theme_option_panel'    
	)
);
/********************* Enable Top Header ****************************/
$wp_customize->add_setting( 'theme_options[enable_top_header]',
	array(
		'default'           => $default['enable_top_header'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_top_header]',
	array(
		'label'    => esc_html__( 'Enable Top Header', 'business-process' ),
		'section'  => 'section_header',
		'type'     => 'checkbox',		
	)
);

/********************* Enable Social Icon ****************************/
$wp_customize->add_setting( 'theme_options[enable_social_icon]',
	array(
		'default'           => $default['enable_social_icon'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_social_icon]',
	array(
		'label'    => esc_html__( 'Enable Social Media', 'business-process' ),
		'section'  => 'section_header',
		'type'     => 'checkbox',		
		'active_callback' => 'business_process_top_bar',
	)
);

/************************  Top Header Left Part  ******************/
$wp_customize->add_setting('theme_options[top_header_left]', 
	array(
	'default' 			=> $default['top_header_left'],
	'sanitize_callback' => 'business_process_sanitize_select'
	)
);

$wp_customize->add_control('theme_options[top_header_left]', 
	array(		
	'label' 	=> esc_html__('Top Left Header Option', 'business-process'),
	'section' 	=> 'section_header',
	'settings'  => 'theme_options[top_header_left]',
	'type' 		=> 'select',
	'active_callback' => 'business_process_top_bar',
	'choices' 	=>  array(
			'select' 	=> esc_html__('None', 'business-process'),
			'menu' 	=> esc_html__('Menu', 'business-process'),
			'phone-number' 	=> esc_html__('Phone Number', 'business-process'),
			'opening-time' 	=> esc_html__('Opening Time', 'business-process'),		
		)
	)
);
/************************  Top Header Right Part  ******************/
$wp_customize->add_setting('theme_options[top_header_right]', 
	array(
	'default' 			=> $default['top_header_right'],
	'sanitize_callback' => 'business_process_sanitize_select'
	)
);

$wp_customize->add_control('theme_options[top_header_right]', 
	array(		
	'label' 	=> esc_html__('Top Left Header Option', 'business-process'),
	'section' 	=> 'section_header',
	'settings'  => 'theme_options[top_header_right]',
	'type' 		=> 'select',
	'active_callback' => 'business_process_top_bar',
	'choices' 	=>  array(
			'select' 	=> esc_html__('None', 'business-process'),
			'menu' 	=> esc_html__('Menu', 'business-process'),
			'phone-number' 	=> esc_html__('Phone Number', 'business-process'),
			'opening-time' 	=> esc_html__('Opening Time', 'business-process'),			
		)
	)
);

/************************  Top Header Phone Number  ******************/
$wp_customize->add_setting( 'theme_options[header_number]',
	array(
	'default'           => $default['header_number'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',	
	)
);
$wp_customize->add_control( 'theme_options[header_number]',
	array(
	'label'    => esc_html__( 'Phone Number', 'business-process' ),
	'section'  => 'section_header',
	'type'     => 'text',
	'active_callback' => 'business_process_top_bar',
	
	)
);

/************************  Top Header Opening Time  ******************/
$wp_customize->add_setting( 'theme_options[header_opening_time]',
	array(
	'default'           => $default['header_opening_time'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',	
	)
);
$wp_customize->add_control( 'theme_options[header_opening_time]',
	array(
	'label'    => esc_html__( 'Opening Time', 'business-process' ),
	'section'  => 'section_header',
	'type'     => 'text',
	'active_callback' => 'business_process_top_bar',
	
	)
);

/************************  Header Type ******************/
$wp_customize->add_setting('theme_options[header_type]', 
	array(
	'default' 			=> $default['header_type'],
	'sanitize_callback' => 'business_process_sanitize_select'
	)
);

$wp_customize->add_control('theme_options[header_type]', 
	array(		
	'label' 	=> esc_html__('Header Type', 'business-process'),
	'section' 	=> 'section_header',
	'settings'  => 'theme_options[header_type]',
	'type' 		=> 'radio',	
	'choices' 	=>  array(
			'sticky' 	=> esc_html__('Sticky', 'business-process'),
			'static' 	=> esc_html__('Static', 'business-process'),
			'absolute' 	=> esc_html__('Absolute', 'business-process'),				
		)
	)
);


/************************  Header Callback ******************/
$wp_customize->add_setting( 'theme_options[header_callback]',
	array(
	'default'           => $default['header_callback'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',	
	)
);
$wp_customize->add_control( 'theme_options[header_callback]',
	array(
	'label'    => esc_html__( 'Header Button', 'business-process' ),
	'section'  => 'section_header',
	'type'     => 'text',
	)
);

/************************  Header Callback Url ******************/
$wp_customize->add_setting( 'theme_options[header_callback_url]',
	array(
	'default'           => $default['header_callback_url'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'esc_url_raw',	
	)
);
$wp_customize->add_control( 'theme_options[header_callback_url]',
	array(
	'label'    => esc_html__( 'Header Button Url', 'business-process' ),
	'section'  => 'section_header',
	'type'     => 'text',
	)
);

/****************  Archive Setting Section  ************/
$wp_customize->add_section('section_archive', 
	array(    
	'title'       => esc_html__( 'Archive Page Setting', 'business-process'),
	'panel'       => 'theme_option_panel'    
	)
);

/************************ Post Content ******************/
$wp_customize->add_setting('theme_options[post_content]', 
	array(
	'default' 			=> $default['post_content'],
	'sanitize_callback' => 'business_process_sanitize_select'
	)
);

$wp_customize->add_control('theme_options[post_content]', 
	array(		
	'label' 	=> esc_html__( 'Post Content', 'business-process'),
	'section' 	=> 'section_archive',
	'settings'  => 'theme_options[post_content]',
	'type' 		=> 'select',
	'choices' 	=>  array(
			'excerpt' 	=> esc_html__( 'Excerpt', 'business-process'),
			'content' 	=> esc_html__( 'Full Content', 'business-process'),			
		)
	)
);

/************************** Post length ********************************/
 $wp_customize->add_setting( 'theme_options[post_length]', 
 	array(
 	'default'			=> $default['post_length'],
 	'sanitize_callback'	=> 'business_process_sanitize_number_range'	
 	) 
);
$wp_customize->add_control( 'theme_options[post_length]', 
	array(
		'label'		=> esc_html__( 'Post length', 'business-process'),
		'settings'  	=> 'theme_options[post_length]',
		'section'		=> 'section_archive',
		'type'			=> 'number',
		'input_attrs'	=> array( 'min' => 10, 'max' => 1000 , 'step' => 1, 'style' => 'width: 115px;'),
		'active_callback'	=> 'business_process_post_length'
	)
);

/************************ Archive Button Tile ********************/
$wp_customize->add_setting( 'theme_options[archive_button]', 
	array(
	'default'		=> $default['archive_button'],
	'sanitize_callback'	=> 'sanitize_text_field',	
	)
);
$wp_customize->add_control( 'theme_options[archive_button]',
	array(
	'label'		=> esc_html__( 'Buton Title', 'business-process' ),
	'settings'	=> 'theme_options[archive_button]',
	'section'	=> 'section_archive',
	'type'		=> 'text',	
	)
);

/****************  General Setting Section ************/
$wp_customize->add_section('section_general', 
	array(    
	'title'       => esc_html__('General Setting', 'business-process'),
	'panel'       => 'theme_option_panel'    
	)
);

/********************* Enable Breadcrumb ****************************/
$wp_customize->add_setting( 'theme_options[enable_breadcrumb]',
	array(
		'default'           => $default['enable_breadcrumb'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_breadcrumb]',
	array(
		'label'    => esc_html__( 'Enable Breadcrumb', 'business-process' ),
		'section'  => 'section_general',
		'type'     => 'checkbox',		
	)
);

/**********************  Layout Options ***************************/
$wp_customize->add_setting('theme_options[layout_options]', 
	array(
	'default' 			=> $default['layout_options'],
	'sanitize_callback' => 'business_process_sanitize_select',
	)
);

$wp_customize->add_control(new Business_Process_Image_Radio_Control($wp_customize, 'theme_options[layout_options]', 
	array(		
	'label' 	=> esc_html__('Layout Options', 'business-process'),
	'section' 	=> 'section_general',
	'settings'  => 'theme_options[layout_options]',
	'type' 		=> 'radio-image',
	'choices' 	=> array(		
		'left' 			=> get_template_directory_uri() . '/assets/img/left-sidebar.png',							
		'right' 		=> get_template_directory_uri() . '/assets/img/right-sidebar.png',
		'no-sidebar' 	=> get_template_directory_uri() . '/assets/img/no-sidebar.png',
		),	
	))
);

/********************* Enable Author ****************************/
$wp_customize->add_setting( 'theme_options[enable_author]',
	array(
		'default'           => $default['enable_author'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_author]',
	array(
		'label'    => esc_html__( 'Enable Author', 'business-process' ),
		'section'  => 'section_general',
		'type'     => 'checkbox',		
	)
);

/********************* Enable Posted Date ****************************/
$wp_customize->add_setting( 'theme_options[enable_posted_date]',
	array(
		'default'           => $default['enable_posted_date'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_posted_date]',
	array(
		'label'    => esc_html__( 'Enable Posted Date', 'business-process' ),
		'section'  => 'section_general',
		'type'     => 'checkbox',		
	)
);

/********************* Enable Categories ****************************/
$wp_customize->add_setting( 'theme_options[enable_categories]',
	array(
		'default'           => $default['enable_categories'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_categories]',
	array(
		'label'    => esc_html__( 'Enable Category', 'business-process' ),
		'section'  => 'section_general',
		'type'     => 'checkbox',		
	)
);

/************************ Pagination Options ******************/
$wp_customize->add_setting('theme_options[pagination_option]', 
	array(
	'default' 			=> $default['pagination_option'],
	'sanitize_callback' => 'business_process_sanitize_select'
	)
);

$wp_customize->add_control('theme_options[pagination_option]', 
	array(		
	'label' 	=> esc_html__( 'Pagination Options', 'business-process'),
	'section' 	=> 'section_general',
	'settings'  => 'theme_options[pagination_option]',
	'type' 		=> 'select',
	'choices' 	=>  array(
			'default' 	=> esc_html__( 'Default', 'business-process'),
			'numeric' 	=> esc_html__( 'Numeric', 'business-process'),			
		)
	)
);

