<?php
/**
* Repeater customizer
*
* @package Business_Process
*/

/**
* Load scripts for repeater 
*/
  function business_process_enqueue_repeater_scripts() {
    wp_enqueue_script( 'business-process-repeater-script', get_template_directory_uri() . '/inc/customizer/repeater-controller/repeater-script.js',array( 'jquery','jquery-ui-sortable'));
    wp_enqueue_style('business-process-repeater-style',get_template_directory_uri() . '/inc/customizer/repeater-controller/repeater-style.css');
} add_action( 'admin_enqueue_scripts', 'business_process_enqueue_repeater_scripts');

/**
* Repeater customizer
*/
function business_process_repeaters_customize_register( $wp_customize ) {
    
    require get_template_directory().'/inc/customizer/repeater-controller/repeater-class.php';
    

    /**
    * Repeater Sanitize
    */
    function business_process_sanitize_repeater($input){      
        $input_decoded = json_decode( $input, true );
        
        if(!empty($input_decoded)) {
            foreach ($input_decoded as $boxes => $box ){
                foreach ($box as $key => $value){

                    $input_decoded[$boxes][$key] = sanitize_text_field( $value );
                }
            }
            return json_encode($input_decoded);
        }    
        return $input;
    }
    /**
    * Repeater Sanitize for html filter
    */
    function business_process_html_sanitize_repeater($input){      
        $input_decoded = json_decode( $input, true );
        if(!empty($input_decoded)) {
            foreach ($input_decoded as $boxes => $box ){
                foreach ($box as $key => $value){

                    $input_decoded[$boxes][$key] = wp_kses_post( $value );
                }
            }
            return json_encode($input_decoded);
        }    
        return $input;
    }
    
}
add_action( 'customize_register', 'business_process_repeaters_customize_register' );