<?php
/**
 * Home Page Options.
 *
 * @package Business_Process
 */

$default = business_process_get_default_theme_options();

/****************  Add Pannel   ***********************/
$wp_customize->add_panel( 'home_option_panel',
	array(
	'title'      => esc_html__( 'Home Page Options', 'business-process' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	)
);

/****************  Header Setting Section starts ************/
$wp_customize->add_section('section_slider', 
	array(    
	'title'       => esc_html__('Slider Setting', 'business-process'),
	'panel'       => 'home_option_panel'    
	)
);

/********************* Enable Slider ****************************/
$wp_customize->add_setting( 'theme_options[enable_slider]',
	array(
		'default'           => $default['enable_slider'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_slider]',
	array(
		'label'    => esc_html__( 'Enable Slider', 'business-process' ),
		'section'  => 'section_slider',
		'type'     => 'checkbox',		
	)
);

// Setting Slider Category.
$wp_customize->add_setting( 'theme_options[slider_category]',
	array(
	'default'           => $default['slider_category'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new Business_Process_Dropdown_Taxonomies_Control( $wp_customize, 'theme_options[slider_category]',
		array(
		'label'    => esc_html__( 'Select Category', 'business-process' ),
		'section'  => 'section_slider',
		'settings' => 'theme_options[slider_category]',
		'priority' => 100,
		'active_callback' => 'business_process_active_slider',
		)
	)
);

// Slider Number.
$wp_customize->add_setting( 'theme_options[slider_number]',
	array(
		'default'           => $default['slider_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_number_range',
		)
);
$wp_customize->add_control( 'theme_options[slider_number]',
	array(
		'label'       => esc_html__( 'No of Slider', 'business-process' ),
		'section'     => 'section_slider',
		'type'        => 'number',
		'priority'    => 100,
		'input_attrs' => array( 'min' => 1, 'max' => 5, 'step' => 1, 'style' => 'width: 115px;' ),
		'active_callback' => 'business_process_active_slider',
	)
);


// Button title
$wp_customize->add_setting('theme_options[slider_button_title]', 
	array(
	'default'           => $default['slider_button_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[slider_button_title]', 
	array(
	'label'       => esc_html__('Button Title', 'business-process'),
	'section'     => 'section_slider',   
	'settings'    => 'theme_options[slider_button_title]',		
	'type'        => 'text',
	'priority'   => 100,	
	'active_callback' => 'business_process_active_slider',
	)
);
// Button Url
$wp_customize->add_setting( 'theme_options[slider_button_url]', 
	array(
	'sanitize_callback'     => 'esc_url_raw',
	'sanitize_js_callback'  =>  'esc_url_raw'
	)
);

$wp_customize->add_control( 'theme_options[slider_button_url]', 
	array(
	'label'     => esc_html__('Button Url','business-process'),
	'type'      => 'url',
	'section'   => 'section_slider',
	'settings'  => 'theme_options[slider_button_url]',
	'priority'   => 100,
	'active_callback' => 'business_process_active_slider',
	)
);

/****************  About us Section ************/
$wp_customize->add_section('section_about_us', 
	array(    
	'title'       => esc_html__('Intro Section', 'business-process'),
	'panel'       => 'home_option_panel'    
	)
);

/************************* Intro Page ******************************************/
$wp_customize->add_setting('theme_options[intro_page]', 
	array(
	'default'           => $default['intro_page'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'business_process_dropdown_pages'
	)
);

$wp_customize->add_control('theme_options[intro_page]', 
	array(
	'label'       => esc_html__('Select About Us Page', 'business-process'),
    'description' => esc_html__( 'Select page from dropdown or leave blank if you want to hide this section.', 'business-process' ), 
	'section'     => 'section_about_us',   
	'settings'    => 'theme_options[intro_page]',		
	'type'        => 'dropdown-pages'
	)
);

/**************** Intro Page First Title **********************************************/
$wp_customize->add_setting('theme_options[intro_title_first]', 
	array(
	'default'           => $default['intro_title_first'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[intro_title_first]', 
	array(
	'label'       => esc_html__('Intro Page Title', 'business-process'),
	'section'     => 'section_about_us',   
	'settings'    => 'theme_options[intro_title_first]',		
	'type'        => 'text',	
	)
);

/****************************  Intro page First ********************************/
$wp_customize->add_setting('theme_options[intro_page_first]', 
	array(
	'default'           => $default['intro_page_first'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'business_process_dropdown_pages'
	)
);

$wp_customize->add_control('theme_options[intro_page_first]', 
	array(
	'label'       => esc_html__('Select Page', 'business-process'),
    'description' => esc_html__( 'Select page from dropdown or leave blank if you want to hide this section.', 'business-process' ), 
	'section'     => 'section_about_us',   
	'settings'    => 'theme_options[intro_page_first]',		
	'type'        => 'dropdown-pages'
	)
);

/******************* Intro Page Second Title *********************************/
$wp_customize->add_setting('theme_options[intro_title_second]', 
	array(
	'default'           => $default['intro_title_second'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[intro_title_second]', 
	array(
	'label'       => esc_html__('Intro Page Title', 'business-process'),
	'section'     => 'section_about_us',   
	'settings'    => 'theme_options[intro_title_second]',		
	'type'        => 'text',	
	)
);

/********************* Intro page Second *******************************************/
$wp_customize->add_setting('theme_options[intro_page_second]', 
	array(
	'default'           => $default['intro_page_second'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'business_process_dropdown_pages'
	)
);

$wp_customize->add_control('theme_options[intro_page_second]', 
	array(
	'label'       => esc_html__('Select Page', 'business-process'),
    'description' => esc_html__( 'Select page from dropdown or leave blank if you want to hide this section.', 'business-process' ), 
	'section'     => 'section_about_us',   
	'settings'    => 'theme_options[intro_page_second]',		
	'type'        => 'dropdown-pages'
	)
);

/******************** Counter Section **************************************/
$wp_customize->add_setting( 'theme_options[counter_secton]', array(
    'sanitize_callback' => 'business_process_sanitize_repeater',
    'default' => json_encode(
        array(
            array(
                'counter_number'=> '',
                'counter_title' => '',
                'counter_icon'  => '',
            )
        )
    )
));

$wp_customize->add_control(  new Business_Process_Repeater_Controler( $wp_customize, 'theme_options[counter_secton]', 
    array(
        'label'                        => esc_html__('Counter Options','business-process'),
        'section'                      => 'section_about_us',
        'business_process_box_label'         => esc_html__('Counter','business-process'),
        'business_process_box_add_control'   => esc_html__('Add Counter','business-process'),
    ),
    array(
        'counter_number' => array(
        'type'        => 'number',
        'label'       => esc_html__( 'Number', 'business-process' ),
        'default'     => '',	            
        ),
            
        'counter_title' => array(
        'type'        => 'text',
        'label'       => esc_html__( 'Title', 'business-process' ),
        'default'     => '',		       
    	),

        'counter_icon' => array(
        'type'        => 'text',
        'label'       => esc_html__( 'Icon', 'business-process' ),
        'description' => esc_html__( 'Enter font awsome icon. Eg: fa fa-tasks', 'business-process' ), 
        'default'     => '',		       
    	),	
    )
));

/****************  Service Section ************/
$wp_customize->add_section('section_service', 
	array(    
	'title'       => esc_html__('Service Section', 'business-process'),
	'panel'       => 'home_option_panel'    
	)
);

/********************* Service Section ****************************/
$wp_customize->add_setting( 'theme_options[enable_service]',
	array(
		'default'           => $default['enable_service'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_service]',
	array(
		'label'    => esc_html__( 'Enable Service Section', 'business-process' ),
		'section'  => 'section_service',
		'type'     => 'checkbox',		
	)
);
/**************** Service  Title **********************************************/
$wp_customize->add_setting('theme_options[service_section_title]', 
	array(
	'default'           => $default['service_section_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[service_section_title]', 
	array(
	'label'       => esc_html__('Service Section Title', 'business-process'),
	'section'     => 'section_service',   
	'settings'    => 'theme_options[service_section_title]',		
	'type'        => 'text',	
	)
);

/********************* Setting Service Category. *****************************************/
$wp_customize->add_setting( 'theme_options[service_category]',
	array(
	'default'           => $default['service_category'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new Business_Process_Dropdown_Taxonomies_Control( $wp_customize, 'theme_options[service_category]',
		array(
		'label'    => esc_html__( 'Select Category', 'business-process' ),
		'section'  => 'section_service',
		'settings' => 'theme_options[service_category]',
		'priority' => 100,
		)
	)
);



/************************** Service Section Number **************************************/
$wp_customize->add_setting( 'theme_options[service_number]',
	array(
		'default'           => $default['service_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_number_range',
		)
);
$wp_customize->add_control( 'theme_options[service_number]',
	array(
		'label'       => esc_html__( 'Select Number', 'business-process' ),
		'section'     => 'section_service',
		'type'        => 'number',
		'priority'    => 100,
		'input_attrs' => array( 'min' => 3, 'max' => 9, 'step' => 3, 'style' => 'width: 115px;' ),
	)
);

/****************   Testimonial Section ************/
$wp_customize->add_section('section_testimonial', 
	array(    
	'title'       => esc_html__('Testimonial Section', 'business-process'),
	'panel'       => 'home_option_panel'    
	)
);

/********************* Testimonial Section Enable ****************************/
$wp_customize->add_setting( 'theme_options[enable_testimonial]',
	array(
		'default'           => $default['enable_testimonial'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_testimonial]',
	array(
		'label'    => esc_html__( 'Enable Testimonial Section', 'business-process' ),
		'section'  => 'section_testimonial',
		'type'     => 'checkbox',		
	)
);
/**************** Testimonial  Title **********************************************/
$wp_customize->add_setting('theme_options[testimonial_section_title]', 
	array(
	'default'           => $default['testimonial_section_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[testimonial_section_title]', 
	array(
	'label'       => esc_html__('Testimonial Section Title', 'business-process'),
	'section'     => 'section_testimonial',   
	'settings'    => 'theme_options[testimonial_section_title]',		
	'type'        => 'text',	
	)
);

/********************* Testimonial Category *****************************************/
$wp_customize->add_setting( 'theme_options[testimonial_category]',
	array(
	'default'           => $default['testimonial_category'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new Business_Process_Dropdown_Taxonomies_Control( $wp_customize, 'theme_options[testimonial_category]',
		array(
		'label'    => esc_html__( 'Select Category', 'business-process' ),
		'section'  => 'section_testimonial',
		'settings' => 'theme_options[testimonial_category]',
		'priority' => 100,
		)
	)
);

/************************** Testimonial Section Number **************************************/
$wp_customize->add_setting( 'theme_options[testimonial_number]',
	array(
		'default'           => $default['testimonial_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_number_range',
		)
);
$wp_customize->add_control( 'theme_options[testimonial_number]',
	array(
		'label'       => esc_html__( 'Select Number', 'business-process' ),
		'section'     => 'section_testimonial',
		'type'        => 'number',
		'priority'    => 100,
		'input_attrs' => array( 'min' => 1, 'max' => 6, 'step' => 1, 'style' => 'width: 115px;' ),
	)
);

/****************   Blog Section ************/
$wp_customize->add_section('section_blog', 
	array(    
	'title'       => esc_html__('Blog Section', 'business-process'),
	'panel'       => 'home_option_panel'    
	)
);

/********************* Blog Section Enable ****************************/
$wp_customize->add_setting( 'theme_options[enable_blog]',
	array(
		'default'           => $default['enable_blog'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_blog]',
	array(
		'label'    => esc_html__( 'Enable Blog Section', 'business-process' ),
		'section'  => 'section_blog',
		'type'     => 'checkbox',		
	)
);
/************************  Blog layout  ******************/
$wp_customize->add_setting('theme_options[blog_layout]', 
	array(
	'default' 			=> $default['blog_layout'],
	'sanitize_callback' => 'business_process_sanitize_select'
	)
);

$wp_customize->add_control('theme_options[blog_layout]', 
	array(		
	'label' 	=> esc_html__('Blog layout', 'business-process'),
	'section' 	=> 'section_blog',
	'settings'  => 'theme_options[blog_layout]',
	'type' 		=> 'select',
	'choices' 	=>  array(
			'layout-1' 	=> esc_html__('layout 1', 'business-process'),
			'layout-2' 	=> esc_html__('layout 2', 'business-process'),
		)
	)
);

/**************** Blog  Title **********************************************/
$wp_customize->add_setting('theme_options[blog_section_title]', 
	array(
	'default'           => $default['blog_section_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[blog_section_title]', 
	array(
	'label'       => esc_html__('Blog Section Title', 'business-process'),
	'section'     => 'section_blog',   
	'settings'    => 'theme_options[blog_section_title]',		
	'type'        => 'text',	
	)
);
/********************* Blog Category *****************************************/
$wp_customize->add_setting( 'theme_options[blog_category]',
	array(
	'default'           => $default['blog_category'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new Business_Process_Dropdown_Taxonomies_Control( $wp_customize, 'theme_options[blog_category]',
		array(
		'label'    => esc_html__( 'Select Category', 'business-process' ),
		'section'  => 'section_blog',
		'settings' => 'theme_options[blog_category]',
		'priority' => 100,
		)
	)
);

/************************** Blog Section Number **************************************/
$wp_customize->add_setting( 'theme_options[blog_number]',
	array(
		'default'           => $default['blog_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_number_range',
		)
);
$wp_customize->add_control( 'theme_options[blog_number]',
	array(
		'label'       => esc_html__( 'Select Number', 'business-process' ),
		'section'     => 'section_blog',
		'type'        => 'number',
		'priority'    => 100,
		'input_attrs' => array( 'min' => 1, 'max' => 6, 'step' => 3, 'style' => 'width: 115px;' ),
	)
);

/****************   Contact Section ************/
$wp_customize->add_section('section_contact', 
	array(    
	'title'       => esc_html__('Contact Section', 'business-process'),
	'panel'       => 'home_option_panel'    
	)
);

/********************* Contact Section Enable ****************************/
$wp_customize->add_setting( 'theme_options[enable_contact]',
	array(
		'default'           => $default['enable_blog'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_contact]',
	array(
		'label'    => esc_html__( 'Enable Contact Section', 'business-process' ),
		'section'  => 'section_contact',
		'type'     => 'checkbox',		
	)
);

/**************** Contact  Title **********************************************/
$wp_customize->add_setting('theme_options[contact_section_title]', 
	array(
	'default'           => $default['contact_section_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[contact_section_title]', 
	array(
	'label'       => esc_html__('Contact Section Title', 'business-process'),
	'section'     => 'section_contact',   
	'settings'    => 'theme_options[contact_section_title]',		
	'type'        => 'text',	
	)
);
/**************** Contact  Description  **********************************************/
$wp_customize->add_setting('theme_options[contact_section_desc]', 
	array(
	'default'           => $default['contact_section_desc'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[contact_section_desc]', 
	array(
	'label'       => esc_html__('Contact Section Description', 'business-process'),
	'section'     => 'section_contact',   
	'settings'    => 'theme_options[contact_section_desc]',		
	'type'        => 'text',	
	)
);
/********************* Contact Image ****************************/
$wp_customize->add_setting( 'theme_options[contact_image_upload]',
	array(
		'default'           => $default['contact_image_upload'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw',
	)
);
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'theme_options[contact_image_upload]',
	array(
		'label'    => esc_html__( 'Upload Image', 'business-process' ),
		'section'  => 'section_contact',
		'settings' => 'theme_options[contact_image_upload]',	
	)
));
/**************** Contact  Form  **********************************************/
$wp_customize->add_setting('theme_options[contact_section_form]', 
	array(
	'default'           => $default['contact_section_form'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'business_process_dropdown_pages'
	)
);
$wp_customize->add_control('theme_options[contact_section_form]', 
	array(
	'label'       => esc_html__('Select Contact Page', 'business-process'),
	'section'     => 'section_contact',   
	'settings'    => 'theme_options[contact_section_form]',		
	'type'        => 'dropdown-pages',	
	)
);

/****************   Client Section ************/
$wp_customize->add_section('section_client', 
	array(    
	'title'       => esc_html__('Client Section', 'business-process'),
	'panel'       => 'home_option_panel'    
	)
);

/********************* Client Section Enable ****************************/
$wp_customize->add_setting( 'theme_options[enable_client]',
	array(
		'default'           => $default['enable_blog'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'business_process_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_client]',
	array(
		'label'    => esc_html__( 'Enable Client Section', 'business-process' ),
		'section'  => 'section_client',
		'type'     => 'checkbox',		
	)
);
/**************** Client Title **********************************************/
$wp_customize->add_setting('theme_options[client_section_title]', 
	array(
	'default'           => $default['client_section_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[client_section_title]', 
	array(
	'label'       => esc_html__('Client Section Title', 'business-process'),
	'section'     => 'section_client',   
	'settings'    => 'theme_options[client_section_title]',		
	'type'        => 'text',	
	)
);
/**************** Client Logo **********************************************/
$wp_customize->add_setting( 'theme_options[client_logo_section]', array(
    'sanitize_callback' => 'business_process_sanitize_repeater',
    'default' => json_encode(
        array(
            array(
                'client_logo'=> '',               
            )
        )
    )
));


$wp_customize->add_control(  new Business_Process_Repeater_Controler( $wp_customize, 'theme_options[client_logo_section]', 
    array(
        'label'                        => esc_html__('Client Logo Options','business-process'),
        'section'                      => 'section_client',
        'business_process_box_label'         => esc_html__('Logo','business-process'),
        'business_process_box_add_control'   => esc_html__('Add Logo','business-process'),
    ),
    array(
        'client_logo' => array(
        'type'        => 'upload',
        'label'       => esc_html__( 'Client Logo', 'business-process' ),
        'default'     => '',	            
        ),           
    )
));