<?php
/**
 * Default theme options.
 *
 * @package Business_Process
 */

if ( ! function_exists( 'business_process_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
function business_process_get_default_theme_options() {

	$defaults = array();

	/********************* Header Setting *************************/
	$defaults['site_identity']				= 'title-text';
	$defaults['enable_top_header']			= true;
	$defaults['enable_social_icon']			= true;
	$defaults['top_header_left']			= 'opening-time';
	$defaults['top_header_right']			= 'phone-number';
	$defaults['header_number']				= esc_html__('+12-4578965412','business-process');
	$defaults['header_opening_time']		= esc_html__('8Am - 5Pm','business-process');
	$defaults['header_type']				= 'static';
	$defaults['header_callback']			= esc_html__( 'Send Request', 'business-process' ) ;	
	$defaults['header_callback_url']		= '';

	/********************* Slider Setting *************************/
	$defaults['enable_slider']				= false;
	$defaults['slider_category']			= 0;
	$defaults['slider_number']				= 3;
	$defaults['slider_button_title']		= esc_html__( 'Buy Now', 'business-process');
	$defaults['slider_button_url']			= '';

	/********************* About Us Setting *************************/
	$defaults['intro_page']					= '';
	$defaults['intro_page_first']			= '';
	$defaults['intro_title_first']			= esc_html__( 'Mission', 'business-process' );
	$defaults['intro_page_second']			= '';
	$defaults['intro_title_second']			= esc_html__( 'Vision', 'business-process' );
	$defaults['counter_secton']	    		= '';

	/********************* Service Section Setting *************************/
	$defaults['enable_service']				= false;
	$defaults['service_section_title']		= esc_html__( 'What We Do', 'business-process' );
	$defaults['service_category']			= 0;
	$defaults['service_number']				= 3;

	/******************************  Testimonial Section    *********************************/
	$defaults['enable_testimonial']			= false;	
	$defaults['testimonial_section_title'] 	= esc_html__( 'WHAT CLIENTS SAY ABOUT US', 'business-process' );
	$defaults['testimonial_category']   	= 0;
	$defaults['testimonial_number']     	= 3;	

	/******************************  Blog Section    *********************************/
	$defaults['enable_blog']				= false;	
	$defaults['blog_section_title'] 		= esc_html__( 'Latest Blog', 'business-process' );
	$defaults['blog_category']      		= 0;
	$defaults['blog_number']      			= 3;	
	$defaults['blog_layout']    			= 'layout-1';			
	
	/******************************  Contact Section    *********************************/
	$defaults['enable_contact']				= false;	
	$defaults['contact_section_title'] 		= esc_html__( 'Contact Us', 'business-process' );
	$defaults['contact_section_desc']		= '';
	$defaults['contact_section_form'] 		= '';
	$defaults['contact_image_upload'] 		= '';
	
	/******************************  Client Section    *********************************/
	$defaults['enable_client']				= false;	
	$defaults['client_section_title'] 		= esc_html__( 'Our Partners', 'business-process' );
	$defaults['client_logo_section']		= '';


	/****************************** Archive Setting *************************************/
	$defaults['post_content']      			= 'excerpt';
	$defaults['post_length']				= 25;
	$defaults['archive_button']				= esc_html( 'Read More', 'business-process' );

	/******************************  General Setting    *********************************/
	$defaults['layout_options']				= 'right';	
	$defaults['pagination_option']			= 'default';	
	$defaults['enable_breadcrumb']			= true;	
	$defaults['enable_author']				= true;	
	$defaults['enable_posted_date']			= true;	
	$defaults['enable_categories']			= true;	


	/************************************* Information Page  ***************/
	for ($i=1; $i < 4 ; $i++) { 
		$defaults['about_title_'.$i]		= '';
		$defaults['about_page_'.$i]			= '';
	}

	/********************* About Counter Section ***********************/
	$defaults['about_counter_secton']	    = '';

	/********************* About  Section ***********************/
	$defaults['about_client_section_title']	 =  esc_html__( 'Our Partners', 'business-process' );
	$defaults['about_client_logo_section']	 = '';

	return $defaults;	

}

endif;


/**
*  Get theme options
*/
if ( ! function_exists( 'business_process_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function business_process_get_option( $key ) {

		$default_options = business_process_get_default_theme_options();

		if ( empty( $key ) ) {
			return;
		}

		$theme_options = (array)get_theme_mod( 'theme_options' );
		$theme_options = wp_parse_args( $theme_options, $default_options );

		$value = null;

		if ( isset( $theme_options[ $key ] ) ) {
			$value = $theme_options[ $key ];
		}

		return $value;

	}

endif;
