<?php
/**
 * About Page Options.
 *
 * @package Business_Process
 */

$default = business_process_get_default_theme_options();

/****************  Add Pannel   ***********************/
$wp_customize->add_panel( 'about_option_panel',
	array(
	'title'      => esc_html__( 'About Page Options', 'business-process' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	)
);

/****************  Information Page  ************/
$wp_customize->add_section('section_about_page', 
	array(    
	'title'       => esc_html__('Information Section', 'business-process'),
	'panel'       => 'about_option_panel'    
	)
);

for ($i=1; $i < 4  ; $i++) { 
	/**************** Intro Page First Title **********************************************/
	$wp_customize->add_setting('theme_options[about_title_'.$i.']', 
		array(
		'default'           => $default['about_title_'.$i],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'sanitize_text_field'
		)
	);

	$wp_customize->add_control('theme_options[about_title_'.$i.']', 
		array(
		'label'       => esc_html__('Information Page Title', 'business-process'),
		'section'     => 'section_about_page',   
		'settings'    => 'theme_options[about_title_'.$i.']',		
		'type'        => 'text',	
		)
	);

	/****************************  Information page First ********************************/
	$wp_customize->add_setting('theme_options[about_page_'.$i.']', 
		array(
		'default'           => $default['about_page_'.$i],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'business_process_dropdown_pages'
		)
	);

	$wp_customize->add_control('theme_options[about_page_'.$i.']', 
		array(
		'label'       => esc_html__('Select Page', 'business-process'),
	    'description' => esc_html__( 'Select page from dropdown or leave blank if you want to hide this section.', 'business-process' ), 
		'section'     => 'section_about_page',   
		'settings'    => 'theme_options[about_page_'.$i.']',		
		'type'        => 'dropdown-pages'
		)
	);
}
/****************  Counter Section ************/
$wp_customize->add_section('section_counter_about', 
	array(    
	'title'       => esc_html__('Counter Section', 'business-process'),
	'panel'       => 'about_option_panel'    
	)
);

/******************** Counter Section **************************************/
$wp_customize->add_setting( 'theme_options[about_counter_secton]', array(
    'sanitize_callback' => 'business_process_sanitize_repeater',
    'default' => json_encode(
        array(
            array(
                'counter_number'=> '',
                'counter_title' => '',
                'counter_icon'  => '',
            )
        )
    )
));

$wp_customize->add_control(  new Business_Process_Repeater_Controler( $wp_customize, 'theme_options[about_counter_secton]', 
    array(
        'label'                        => esc_html__('Counter Options','business-process'),
        'section'                      => 'section_counter_about',
        'business_process_box_label'         => esc_html__('Counter','business-process'),
        'business_process_box_add_control'   => esc_html__('Add Counter','business-process'),
    ),
    array(
        'counter_number' => array(
        'type'        => 'number',
        'label'       => esc_html__( 'Number', 'business-process' ),
        'default'     => '',	            
        ),
            
        'counter_title' => array(
        'type'        => 'text',
        'label'       => esc_html__( 'Title', 'business-process' ),
        'default'     => '',		       
    	),

        'counter_icon' => array(
        'type'        => 'text',
        'label'       => esc_html__( 'Icon', 'business-process' ),
        'description' => esc_html__( 'Enter font awsome icon. Eg: fa fa-tasks', 'business-process' ), 
        'default'     => '',		       
    	),	
    )
));
	
/****************   Client Section ************/
$wp_customize->add_section('section_client_about', 
	array(    
	'title'       => esc_html__('Client Section', 'business-process'),
	'panel'       => 'about_option_panel'    
	)
);


/**************** Client Title **********************************************/
$wp_customize->add_setting('theme_options[about_client_section_title]', 
	array(
	'default'           => $default['about_client_section_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[about_client_section_title]', 
	array(
	'label'       => esc_html__('Client Section Title', 'business-process'),
	'section'     => 'section_client_about',   
	'settings'    => 'theme_options[about_client_section_title]',		
	'type'        => 'text',	
	)
);
/**************** Client Logo **********************************************/
$wp_customize->add_setting( 'theme_options[about_client_logo_section]', array(
    'sanitize_callback' => 'business_process_sanitize_repeater',
    'default' => json_encode(
        array(
            array(
                'client_logo'=> '',               
            )
        )
    )
));


$wp_customize->add_control(  new Business_Process_Repeater_Controler( $wp_customize, 'theme_options[about_client_logo_section]', 
    array(
        'label'                        => esc_html__('Client Logo Options','business-process'),
        'section'                      => 'section_client_about',
        'business_process_box_label'         => esc_html__('Logo','business-process'),
        'business_process_box_add_control'   => esc_html__('Add Logo','business-process'),
    ),
    array(
        'client_logo' => array(
        'type'        => 'upload',
        'label'       => esc_html__( 'Client Logo', 'business-process' ),
        'default'     => '',	            
        ),           
    )
));
