<?php
/**
 * Business Process Theme Customizer
 *
 * @package Business_Process
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function business_process_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	$wp_customize->register_section_type( 'Business_Porcess_Customize_Section_Upsell' );

	// Register sections.
	$wp_customize->add_section(
		new Business_Porcess_Customize_Section_Upsell(
			$wp_customize,
			'theme_upsell',
			array(
				'title'    => esc_html__( 'Business Process Pro', 'business-process' ),
				'pro_text' => esc_html__( 'Buy Pro', 'business-process' ),
				'pro_url'  => 'https://rigorousthemes.com/downloads/business-process-pro/',
				'priority' => 1,
			)
		)
	);


	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'business_process_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'business_process_customize_partial_blogdescription',
		) );
	}
	// Sanitization.
	require_once trailingslashit( get_template_directory() ) . '/inc/customizer/sanitize.php';

	// Active callback.
	require_once trailingslashit( get_template_directory() ) . '/inc/customizer/active.php';

	// Active callback.
	require_once trailingslashit( get_template_directory() ) . '/inc/customizer/theme-options.php';	

	// Load Home Page Option.
	require_once trailingslashit( get_template_directory() ) . '/inc/customizer/home-options.php';

	// Load Home Page Option.
	require_once trailingslashit( get_template_directory() ) . '/inc/customizer/about-options.php';	

}
add_action( 'customize_register', 'business_process_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function business_process_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function business_process_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function business_process_customize_preview_js() {
	wp_enqueue_script( 'business-process-customizer', get_template_directory_uri() . '/assets/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'business_process_customize_preview_js' );

/**
 *  Customizer Control 
 */
function business_process_customize_backend_scripts() {

	wp_enqueue_style( 'business-process-admin-customizer-style', get_template_directory_uri() . '/inc/customizer/css/customizer-style.css' );
	
	wp_enqueue_script( 'business-process-admin-customizer', get_template_directory_uri() . '/inc/customizer/js/customizer-scipt.js', array( ), '20151215', true );
}
add_action( 'customize_controls_enqueue_scripts', 'business_process_customize_backend_scripts', 10 );
