<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Business_Process
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php do_action( 'wp_body_open' ); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'business-process' ); ?></a>

	<header id="masthead" class="site-header">
		<?php $site_identity 		= business_process_get_option( 'site_identity' );
		$enable_top_header 			= business_process_get_option( 'enable_top_header' );
		$enable_social_icon 		= business_process_get_option( 'enable_social_icon' );
		$top_header_left 			= business_process_get_option( 'top_header_left' );
		$top_header_right 			= business_process_get_option( 'top_header_right' );
		$header_number 				= business_process_get_option( 'header_number' );
		$header_opening_time 		= business_process_get_option( 'header_opening_time' );
		$header_type 				= business_process_get_option( 'header_type' );
		$header_callback 			= business_process_get_option( 'header_callback' );
		$header_callback_url 		= business_process_get_option( 'header_callback_url' );	
		$menu_class = 'no-button';
		if( !empty( $header_callback ) ){
			$menu_class = 'has-button';
		}	

		if ( true == $enable_top_header ): ?>
			<div class="top-bar">
				<div class="container">
					<div class="top-bar-wrapper">
						<div class="left-side">

							<?php if( 'menu' == $top_header_left) :?>
								<?php wp_nav_menu( array(
									'theme_location'  => 'top-menu',
									'container'       => false,					
									'depth'           => 1,
									'fallback_cb'     => false,

									) ); 
								?>
							<?php endif;?>	

							<?php if( 'opening-time' == $top_header_left) :?>						
								<div class="quick-info">
									<?php echo esc_html( $header_opening_time ); ?>
								</div>

							<?php endif; ?>

							<?php if( 'phone-number' == $top_header_left) :?>						
								<div class="call-info"><?php echo esc_html__( 'Call Us:', 'business-process');?>
									<a href="tel:<?php esc_attr( $header_number );?>"><?php echo esc_html( $header_number ); ?></a>
								</div>

							<?php endif; ?>							

						</div>
						<div class="right-side">
							<?php if( 'menu' == $top_header_right) :?>
								<?php wp_nav_menu( array(
									'theme_location'  => 'top-menu',
									'container'       => false,					
									'depth'           => 1,
									'fallback_cb'     => false,

									) ); 
								?>
							<?php endif;?>	

							<?php if( 'opening-time' == $top_header_right) :?>						
								<div class="quick-info">
									<?php echo esc_html( $header_opening_time ); ?>
								</div>

							<?php endif; ?>

							<?php if( 'phone-number' == $top_header_right) :?>						
								<div class="call-info"><?php echo esc_html__( 'Call Us:', 'business-process');?>
									<a href="tel:<?php esc_attr( $header_number );?>"><?php echo esc_html( $header_number ); ?></a>
								</div>

							<?php endif; ?>	

							<?php if ( true == $enable_social_icon ): ?>
								<div class="social-links">
									<?php wp_nav_menu( array(
										'theme_location'  => 'social-media',
										'container'       => false,						
										'depth'           => 1,
										'fallback_cb'     => false,

										) ); 
									?>						
								</div>
							<?php endif; ?>

						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>	
		<div class="hgroup <?php echo esc_attr( $header_type );?> <?php echo esc_attr( $menu_class );?>">
			<div class="container">	
				<div class="site-branding">
			    	<?php 	if ( in_array( $site_identity, array( 'logo-only', 'logo-text','logo-title' ) )  ) { ?>
			    		<div class="site-logo">
			    			<?php the_custom_logo(); ?> 
			    		</div>
					<?php } ?>

					<?php if ( in_array( $site_identity, array( 'title-text', 'title-only', 'logo-text','logo-title' ) ) ) : ?>
						<?php
						if( in_array( $site_identity, array( 'title-text', 'title-only','logo-title' ) )  ) {
							if ( is_front_page() && is_home() ) : ?>
								<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php
							endif;
						} 
						if ( in_array( $site_identity, array( 'title-text', 'logo-text' ) ) ) {
							$description = get_bloginfo( 'description', 'display' );
							if ( $description || is_customize_preview() ) : ?>
								<p class="site-description"><?php echo esc_html( $description ); /* WPCS: xss ok. */ ?></p>
							<?php
							endif; 
						}?>
					<?php endif; ?>
				</div><!-- .site-branding -->					
				<div class="menu-wrap">
					<nav id="site-navigation" class="main-navigation">
						<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php esc_html_e( 'Primary Menu', 'business-process' ); ?></button>
						<?php
						wp_nav_menu( array(
							'theme_location' => 'menu-1',
							'menu_id'        => 'primary-menu',
						) );
						?>
					</nav><!-- #site-navigation -->
				</div>	
				<?php if ( !empty( $header_callback ) ): ?>
					<div class="header-right">					
							<div class="quick-btn">
								<a href="<?php echo esc_url( $header_callback_url );?>"><?php echo esc_html( $header_callback ); ?></a>
							</div>					
					</div>	
				<?php endif; ?>			
			</div>
		</div>

		<?php
		/**
		 * Hook - business_process_action_header.
		 *
		 * @hooked business_process_add_main_header - 10
		 * @hooked business_process_add_custom_header - 15
		 */
		do_action( 'business_process_action_header' );
		?>	
			
	</header><!-- #masthead -->

	<div id="content" class="site-content">
