var $ = jQuery;

$( document ).ready(function() {

  // Mean Menu 
  jQuery('.main-navigation').meanmenu({
    meanMenuContainer: '.site-header',
    meanScreenWidth:"767",
    meanRevealPosition: "right",
  });

  // Featured Sldier
  $('.feature-slider').owlCarousel({
    loop: true,
    nav:true,
    lazyLoad:true,
    dots:false,
    smartSpeed:2500,
    autoplay:true,
    responsive:{
      0:{
        items:1
      },
      600:{
        items:1
      },
      1000:{
        items:1
      }
    }
  });

  //Horizontal Tab
  $('.HorizontalTab').easyResponsiveTabs({
    type: 'default', //Types: default, vertical, accordion
    width: 'auto', //auto or any width like 600px
    fit: true, // 100% fit in a container
    tabidentify: 'hor_1', // The tab groups identifier
    activate: function(event) { // Callback function if tab is switched
      var $tab = $(this);
      var $info = $('#nested-tabInfo');
      var $name = $('span', $info);
      $name.text($tab.text());
      $info.show();
    }
  });

  // Counter
  $('.counter').each(function() {
    var $this = $(this),
    countTo = $this.attr('data-count');
    $({ countNum: $this.text()}).animate({
      countNum: countTo
    },
    {
      duration: 8000,
      easing:'linear',
      step: function() {
      $this.text(Math.floor(this.countNum));
      },
      complete: function() {
        $this.text(this.countNum);
      }
    });  
  });

  // Testimonial Slider
  $('.testimonial-slider').owlCarousel({
    loop:true,
    margin:10,
    nav:false,
    lazyLoad:true,
    dots:true,
    responsive:{
      0:{
        items:1
      },
      600:{
        items:1
      },
      1000:{
        items:1
      }
    }
  });

  // Social Medai Slider
  $('.social-media-slider').owlCarousel({
    loop:true,
    margin:0,
    nav:true,
    lazyLoad:true,
    dots:false,
      responsive:{
      0:{
        items:1
      },
      600:{
        items:1
      },
      1000:{
        items:1
      }
    }
  });

  /* back-to-top button*/
  $('.back-to-top').hide();
  $('.back-to-top').on("click",function(e) {
    e.preventDefault();
    $('html, body').animate({ scrollTop: 0 }, 'slow');
  });

  $(window).scroll(function(){
    var scrollheight =400;
    if( $(window).scrollTop() > scrollheight ) {
    $('.back-to-top').fadeIn();

    }
    else {
    $('.back-to-top').fadeOut();
    }
  });

});


wow = new WOW({
  boxClass:     'wow',      // default
  animateClass: 'animated', // default
  offset:       0,          // default
  mobile:       false,       // default
  live:         true        // default
})

new WOW().init();