<?php 
/**
 * Template part for displaying Featured Classes Section
 *
 * @package Business Networking Conference
 */

$business_networking_conference_about = get_theme_mod( 'business_networking_conference_about_setting',false );
$business_networking_conference_featured_mission_section_title = get_theme_mod( 'business_networking_conference_featured_mission_section_title' );
$business_networking_conference_featured_mission_posts[] = get_theme_mod( 'business_networking_conference_featured_mission_post_' );

?>
<?php if ( $business_networking_conference_about ){?>
<div id="about-section" class="section-content py-5">
    <div class="container">        
        <?php $args = array (
            'post_type'     => 'page',
            'posts_per_page' => 1,
            'post__in'      => $business_networking_conference_featured_mission_posts,
            'orderby'       =>'post__in',
            'ignore_sticky_posts' => true,
        );?>
        <?php
        $loop = new WP_Query($args);
        if ( $loop->have_posts() ) :
            while ($loop->have_posts()) : $loop->the_post(); ?>
            <div class="featured-mission-box">
                <div class="row">
                    <div class="col-lg-6 col-md-6 align-self-center about-us position-relative">
                        <div class="about-img">
                           <?php
                              if ( has_post_thumbnail() ) :
                                the_post_thumbnail();
                              else:
                                ?>
                                <div class="image-container">
                                  <img src="<?php echo get_stylesheet_directory_uri() . '/images/default-header.png'; ?>">
                                </div>
                                <?php
                              endif;
                            ?>
                        </div>
                        <?php if(get_theme_mod('business_networking_conference_image_text') != ''){ ?>
                            <div class="image-outerbox">
                              <div class="image-text">
                                <span class="year-number"><?php echo esc_html(get_theme_mod('business_networking_conference_image_text')); ?></span>
                                <br>
                                <span class="year-text"><?php esc_html_e('Year','business-networking-conference'); ?></span>
                              </div>
                            </div>
                        <?php }?>
                    </div> 

                    <div class="col-lg-6 col-md-6 align-self-center position-relative about_detail">
                        <div class="entry-header">
                            <?php if ( get_theme_mod('business_networking_conference_about_top_text') ) : ?>
                                <p class="who"><?php echo esc_html(get_theme_mod('business_networking_conference_about_top_text'));?></p>
                            <?php endif; ?>
                            <?php if ( get_theme_mod('business_networking_conference_about_text_extra') ) : ?>
                                <h2><?php echo esc_html(get_theme_mod('business_networking_conference_about_text_extra'));?></h2>
                            <?php endif; ?>
                            <div class="vertical-line my-4 ms-5"></div>
                            <?php if( !empty($business_networking_conference_featured_mission_section_title) ): ?>
                                <div class="section-title">
                                    <h3><?php echo esc_html($business_networking_conference_featured_mission_section_title); ?></h3>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="entry-content">
                            <p class="mb-0 about-para"><?php echo wp_trim_words( get_the_content(), 40 ); ?></p>
                        </div>
                        <div class="btn-green my-4">
                            <a href="<?php the_permalink(); ?>">
                            <?php esc_html_e('Read More','business-networking-conference'); ?>
                            </a>
                        </div>  
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
    </div>
</div>
<?php } ?>