<?php
/**
 * Banner Section
 * 
 * @package business_networking_conference
 */
$business_networking_conference_slider = get_theme_mod( 'business_networking_conference_slider_setting',false );
$business_networking_conference_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('business_networking_conference_blog_slide_category'),
  'posts_per_page' => 3,
); ?>

<?php if ( $business_networking_conference_slider ){?>
  <div class="banner">
    <div class="owl-carousel">
      <?php $business_networking_conference_arr_posts = new WP_Query( $business_networking_conference_args );
      if ( $business_networking_conference_arr_posts->have_posts() ) :
        while ( $business_networking_conference_arr_posts->have_posts() ) :
          $business_networking_conference_arr_posts->the_post();
          ?>
          <div class="banner_inner_box">
            <?php
              if ( has_post_thumbnail() ) :
                the_post_thumbnail();
              else:
                ?>
                <div class="banner_inner_box">
                  <img src="<?php echo get_stylesheet_directory_uri() . '/images/slide.jpg'; ?>">
                </div>
                <?php
              endif;
            ?>
            <div class="banner_box">
              <h3 class="my-3"><?php the_title(); ?></a></h3>
              <div class="slide-btns">
                <p class="btn-green mt-4">
                <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Read More','business-networking-conference'); ?></a>
              </p>
              </div>
            </div>
          </div>
        <?php
      endwhile;
      wp_reset_postdata();
      endif; ?>
    </div>
  </div>
<?php } ?>