<?php
/**
 * Business Networking Conference Theme Customizer.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package business_networking_conference
 */

if( ! function_exists( 'business_networking_conference_customize_register' ) ):  
/**
 * Add postMessage support for site title and description for the Theme Customizer.F
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function business_networking_conference_customize_register( $wp_customize ) {
    require get_parent_theme_file_path('/inc/controls/changeable-icon.php');

    require get_parent_theme_file_path('/inc/controls/sortable-control.php');
    
    //Register the sortable control type.
    $wp_customize->register_control_type( 'Business_Networking_Conference_Control_Sortable' ); 
    

    if ( version_compare( get_bloginfo('version'),'4.9', '>=') ) {
        $wp_customize->get_section( 'static_front_page' )->title = __( 'Static Front Page', 'business-networking-conference' );
    }
	
    /* Option list of all post */	
    $business_networking_conference_options_posts = array();
    $business_networking_conference_options_posts_obj = get_posts('posts_per_page=-1');
    $business_networking_conference_options_posts[''] = esc_html__( 'Choose Post', 'business-networking-conference' );
    foreach ( $business_networking_conference_options_posts_obj as $business_networking_conference_posts ) {
    	$business_networking_conference_options_posts[$business_networking_conference_posts->ID] = $business_networking_conference_posts->post_title;
    }
    
    /* Option list of all categories */
    $business_networking_conference_args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'order'                    => 'ASC',
	   'hide_empty'               => 1,
	   'hierarchical'             => 1,
	   'taxonomy'                 => 'category'
    ); 
    $business_networking_conference_option_categories = array();
    $business_networking_conference_category_lists = get_categories( $business_networking_conference_args );
    $business_networking_conference_option_categories[''] = esc_html__( 'Choose Category', 'business-networking-conference' );
    foreach( $business_networking_conference_category_lists as $business_networking_conference_category ){
        $business_networking_conference_option_categories[$business_networking_conference_category->term_id] = $business_networking_conference_category->name;
    }
    
    /** Default Settings */    
    $wp_customize->add_panel( 
        'wp_default_panel',
         array(
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__( 'Default Settings', 'business-networking-conference' ),
            'description' => esc_html__( 'Default section provided by wordpress customizer.', 'business-networking-conference' ),
        ) 
    );
    
    $wp_customize->get_section( 'title_tagline' )->panel                  = 'wp_default_panel';
    $wp_customize->get_section( 'colors' )->panel                         = 'wp_default_panel';
    $wp_customize->get_section( 'header_image' )->panel                   = 'wp_default_panel';
    $wp_customize->get_section( 'background_image' )->panel               = 'wp_default_panel';
    $wp_customize->get_section( 'static_front_page' )->panel              = 'wp_default_panel';
    
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    
    /** Default Settings Ends */
    
    /** Site Title control */
    $wp_customize->add_setting( 
        'header_site_title', 
        array(
            'default'           => false,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_site_title',
        array(
            'label'       => __( 'Show / Hide Site Title', 'business-networking-conference' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    /** Tagline control */
    $wp_customize->add_setting( 
        'header_tagline', 
        array(
            'default'           => false,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_tagline',
        array(
            'label'       => __( 'Show / Hide Tagline', 'business-networking-conference' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('logo_width', array(
        'sanitize_callback' => 'absint', 
    ));

    // Add a control for logo width
    $wp_customize->add_control('logo_width', array(
        'label' => __('Logo Width', 'business-networking-conference'),
        'section' => 'title_tagline',
        'type' => 'number',
        'input_attrs' => array(
            'min' => '50', 
            'max' => '500', 
            'step' => '5', 
    ),
        'default' => '100', 
    ));

    $wp_customize->add_setting( 'business_networking_conference_site_title_size', array(
        'default'           => 30, // Default font size in pixels
        'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
    ) );

    // Add control for site title size
    $wp_customize->add_control( 'business_networking_conference_site_title_size', array(
        'type'        => 'number',
        'section'     => 'title_tagline', // You can change this section to your preferred section
        'label'       => __( 'Site Title Font Size (px)', 'business-networking-conference' ),
        'input_attrs' => array(
            'min'  => 10,
            'max'  => 100,
            'step' => 1,
        ),
    ) );

    /** Responsive Media settings */
    $wp_customize->add_section(
        'business_networking_conference_responsive_media_section',
        array(
            'title' => esc_html__( 'Responsive Media Settings', 'business-networking-conference' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'business_networking_conference_general_settings',
        )
    );

    /** Scroll to top Responsive control */
    $wp_customize->add_setting( 
        'business_networking_conference_resp_scroll_top', 
        array(
            'default' => 1,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_resp_scroll_top',
        array(
            'label'       => __( 'Show Scroll To Top', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_responsive_media_section',
            'type'        => 'checkbox',
        )
    );

        /** Scroll to top Responsive control */
    $wp_customize->add_setting( 
        'business_networking_conference_resp_loader', 
        array(
            'default' => 0,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_resp_loader',
        array(
            'label'       => __( 'Show Preloader', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_responsive_media_section',
            'type'        => 'checkbox',
        )
    );

    /** Responsive Media Ends */

    // Global Color
    $wp_customize->add_section(
        'business_networking_conference_global_color',
        array(
            'title' => esc_html__( 'Global Color Settings', 'business-networking-conference' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'business_networking_conference_general_settings',
        )
    );

    $wp_customize->add_setting('business_networking_conference_primary_color', array(
        'default'           => '#0154F7',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'business_networking_conference_primary_color', array(
        'label'    => __('Theme Primary Color', 'business-networking-conference'),
        'section'  => 'business_networking_conference_global_color',
        'settings' => 'business_networking_conference_primary_color',
    )));    

    /** Post & Pages Settings */
    $wp_customize->add_panel( 
        'business_networking_conference_post_settings',
         array(
            'priority' => 11,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Post & Pages Settings', 'business-networking-conference' ),
            'description' => esc_html__( 'Customize Post & Pages Settings', 'business-networking-conference' ),
        ) 
    );

        /** Post Layouts */
    
    $wp_customize->add_section(
        'business_networking_conference_post_layout_section',
        array(
            'title' => esc_html__( 'Post Layout Settings', 'business-networking-conference' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'business_networking_conference_post_settings',
        )
    );

    $wp_customize->add_setting('business_networking_conference_post_layout_setting', array(
        'default'           => 'right-sidebar',
        'sanitize_callback' => 'business_networking_conference_sanitize_post_layout',
    ));

    $wp_customize->add_control('business_networking_conference_post_layout_setting', array(
        'label'    => __('Post Column Settings', 'business-networking-conference'),
        'section'  => 'business_networking_conference_post_layout_section',
        'settings' => 'business_networking_conference_post_layout_setting',
        'type'     => 'select',
        'choices'  => array(
            'one-column'   => __('One Column', 'business-networking-conference'),
            'right-sidebar'   => __('Right Sidebar', 'business-networking-conference'),
            'left-sidebar'   => __('Left Sidebar', 'business-networking-conference'),
            'three-column'   => __('Three Columns', 'business-networking-conference'),
            'four-column'   => __('Four Columns', 'business-networking-conference'),
        ),
    ));

    $wp_customize->add_setting('business_networking_conference_archive_pagination_alignment',array(
        'default' => 'left-align',
        'sanitize_callback' => 'business_networking_conference_sanitize_pagination_alignment'
    ));
    $wp_customize->add_control('business_networking_conference_archive_pagination_alignment',array(
        'type' => 'select',
        'label' => __('Pagination Alignment','business-networking-conference'),
        'section' => 'business_networking_conference_post_layout_section',
        'choices' => array(
            'right-align' => __('Right Alignment','business-networking-conference'),
            'center-align' => __('Center Alignment','business-networking-conference'),
            'left-align' => __('Left Alignment','business-networking-conference'),
        ),
    ) );

     /** Post Layouts Ends */
     
    /** Post Settings */
    $wp_customize->add_section(
        'business_networking_conference_post_settings',
        array(
            'title' => esc_html__( 'Post Settings', 'business-networking-conference' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'business_networking_conference_post_settings',
        )
    );

    /** Post Heading control */
    $wp_customize->add_setting( 
        'business_networking_conference_post_heading_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_post_heading_setting',
        array(
            'label'       => __( 'Show / Hide Post Heading', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Meta control */
    $wp_customize->add_setting( 
        'business_networking_conference_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Post Meta', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Image control */
    $wp_customize->add_setting( 
        'business_networking_conference_post_image_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_post_image_setting',
        array(
            'label'       => __( 'Show / Hide Post Image', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Content control */
    $wp_customize->add_setting( 
        'business_networking_conference_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Post Content', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_post_settings',
            'type'        => 'checkbox',
        )
    );
    /** Post ReadMore control */
     $wp_customize->add_setting( 'business_networking_conference_read_more_setting', array(
        'default'           => true,
        'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
    ) );

    $wp_customize->add_control( 'business_networking_conference_read_more_setting', array(
        'type'        => 'checkbox',
        'section'     => 'business_networking_conference_post_settings', 
        'label'       => __( 'Display Read More Button', 'business-networking-conference' ),
    ) );

    $wp_customize->add_setting('business_networking_conference_blog_meta_order', array(
        'default' => array('heading', 'author', 'featured-image', 'content','button'),
        'sanitize_callback' => 'business_networking_conference_sanitize_sortable',
    ));
    $wp_customize->add_control(new Business_Networking_Conference_Control_Sortable($wp_customize, 'business_networking_conference_blog_meta_order', array(
        'label' => esc_html__('Post Meta Ordering', 'business-networking-conference'),
        'description' => __('Drag & drop post items to rearrange the ordering ( this control will not function by post format )', 'business-networking-conference') ,
        'section' => 'business_networking_conference_post_settings',
        'choices' => array(
            'heading' => __('heading', 'business-networking-conference') ,
            'author' => __('author', 'business-networking-conference') ,
            'featured-image' => __('featured-image', 'business-networking-conference') ,
            'content' => __('content', 'business-networking-conference') ,
            'button' => __('button', 'business-networking-conference') ,
        ) ,
    )));

    /** Post Settings Ends */

     /** Single Post Settings */
    $wp_customize->add_section(
        'business_networking_conference_single_post_settings',
        array(
            'title' => esc_html__( 'Single Post Settings', 'business-networking-conference' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'business_networking_conference_post_settings',
        )
    );

    /** Single Post Meta control */
    $wp_customize->add_setting( 
        'business_networking_conference_single_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_single_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Meta', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Content control */
    $wp_customize->add_setting( 
        'business_networking_conference_single_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_single_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Content', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Settings Ends */

         // Typography Settings Section
    $wp_customize->add_section('business_networking_conference_typography_settings', array(
        'title'      => esc_html__('Typography Settings', 'business-networking-conference'),
        'priority'   => 30,
        'capability' => 'edit_theme_options',
        'panel' => 'business_networking_conference_general_settings',
    ));

    // Array of fonts to choose from
    $font_choices = array(
        ''               => __('Select', 'business-networking-conference'),
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
        'Libre Baskerville' => 'Libre Baskerville',
    );

    // Heading Font Setting
    $wp_customize->add_setting('business_networking_conference_heading_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'business_networking_conference_sanitize_choicess',
    ));
    $wp_customize->add_control('business_networking_conference_heading_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Heading', 'business-networking-conference'),
        'section' => 'business_networking_conference_typography_settings',
    ));

    // Body Font Setting
    $wp_customize->add_setting('business_networking_conference_body_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'business_networking_conference_sanitize_choicess',
    ));
    $wp_customize->add_control('business_networking_conference_body_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Body', 'business-networking-conference'),
        'section' => 'business_networking_conference_typography_settings',
    ));

    /** Typography Settings Section End */

    /** General Settings */
    $wp_customize->add_panel( 
        'business_networking_conference_general_settings',
         array(
            'priority' => 12,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'General Settings', 'business-networking-conference' ),
            'description' => esc_html__( 'Customize General Settings', 'business-networking-conference' ),
        ) 
    );

    /** General Settings */
    $wp_customize->add_section(
        'business_networking_conference_general_settings',
        array(
            'title' => esc_html__( 'Loader Settings', 'business-networking-conference' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'business_networking_conference_general_settings',
        )
    );

    /** Preloader control */
    $wp_customize->add_setting( 
        'business_networking_conference_header_preloader', 
        array(
            'default' => false,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_header_preloader',
        array(
            'label'       => __( 'Show Preloader', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_general_settings',
            'type'        => 'checkbox',
        )
    );

    /** Header Section Settings */
    $wp_customize->add_section(
        'business_networking_conference_header_section_settings',
        array(
            'title' => esc_html__( 'Header Section Settings', 'business-networking-conference' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'business_networking_conference_home_page_settings',
        )
    );

     /** Email */
    $wp_customize->add_setting(
        'business_networking_conference_header_email',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'business_networking_conference_header_email',
        array(
            'label' => esc_html__( 'Add Mail Address', 'business-networking-conference' ),
            'section' => 'business_networking_conference_header_section_settings',
            'type' => 'text',
        )
    );

      /** Phone */
    $wp_customize->add_setting(
        'business_networking_conference_header_phone',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'business_networking_conference_header_phone',
        array(
            'label' => esc_html__( 'Add Phone', 'business-networking-conference' ),
            'section' => 'business_networking_conference_header_section_settings',
            'type' => 'text',
        )
    );
    $wp_customize->add_setting('business_networking_conference_phone_icon',array(
        'default'   => 'fas fa-phone-volume',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Business_Networking_Conference_Changeable_Icon(
        $wp_customize,'business_networking_conference_phone_icon',array(
        'label' => __('Phone Icon','business-networking-conference'),
        'transport' => 'refresh',
        'section'   => 'business_networking_conference_header_section_settings',
        'type'      => 'icon'
    )));

    /** Sticky Header control */
    $wp_customize->add_setting( 
        'business_networking_conference_sticky_header', 
        array(
            'default' => false,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_sticky_header',
        array(
            'label'       => __( 'Show Sticky Header', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_header_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Add Setting for Menu Font Weight
    $wp_customize->add_setting( 'business_networking_conference_menu_font_weight', array(
        'default'           => '500',
        'sanitize_callback' => 'business_networking_conference_sanitize_font_weight',
    ) );

    // Add Control for Menu Font Weight
    $wp_customize->add_control( 'business_networking_conference_menu_font_weight', array(
        'label'    => __( 'Menu Font Weight', 'business-networking-conference' ),
        'section'  => 'business_networking_conference_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            '100' => __( '100 - Thin', 'business-networking-conference' ),
            '200' => __( '200 - Extra Light', 'business-networking-conference' ),
            '300' => __( '300 - Light', 'business-networking-conference' ),
            '400' => __( '400 - Normal', 'business-networking-conference' ),
            '500' => __( '500 - Medium', 'business-networking-conference' ),
            '600' => __( '600 - Semi Bold', 'business-networking-conference' ),
            '700' => __( '700 - Bold', 'business-networking-conference' ),
            '800' => __( '800 - Extra Bold', 'business-networking-conference' ),
            '900' => __( '900 - Black', 'business-networking-conference' ),
        ),
    ) );

    // Add Setting for Menu Text Transform
    $wp_customize->add_setting( 'business_networking_conference_menu_text_transform', array(
        'default'           => 'capitalize',
        'sanitize_callback' => 'business_networking_conference_sanitize_text_transform',
    ) );

    // Add Control for Menu Text Transform
    $wp_customize->add_control( 'business_networking_conference_menu_text_transform', array(
        'label'    => __( 'Menu Text Transform', 'business-networking-conference' ),
        'section'  => 'business_networking_conference_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            'none'       => __( 'None', 'business-networking-conference' ),
            'capitalize' => __( 'Capitalize', 'business-networking-conference' ),
            'uppercase'  => __( 'Uppercase', 'business-networking-conference' ),
            'lowercase'  => __( 'Lowercase', 'business-networking-conference' ),
        ),
    ) );

    $wp_customize->add_setting('business_networking_conference_menus_style',array(
        'default' => '',
        'sanitize_callback' => 'business_networking_conference_sanitize_choices'
	));
	$wp_customize->add_control('business_networking_conference_menus_style',array(
        'type' => 'select',
		'label' => __('Menu Hover Style','business-networking-conference'),
		'section' => 'business_networking_conference_header_section_settings',
		'choices' => array(
         'None' => __('None','business-networking-conference'),
         'Zoom In' => __('Zoom In','business-networking-conference'),
      ),
	));

    /** Socail Section Settings */
    $wp_customize->add_section(
        'business_networking_conference_social_section_settings',
        array(
            'title' => esc_html__( 'Social Media Section Settings', 'business-networking-conference' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'business_networking_conference_home_page_settings',
        )
    );

    /** Socail Section control */
    $wp_customize->add_setting( 
        'business_networking_conference_social_icon_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_social_icon_setting',
        array(
            'label'       => __( 'Show Social Icon', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_social_section_settings',
            'type'        => 'checkbox',
        )
    );

    /**  Social Link 1 */
    $wp_customize->add_setting(
        'business_networking_conference_social_link_1',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'business_networking_conference_social_link_1',
        array(
            'label' => esc_html__( 'Add Facebook Link', 'business-networking-conference' ),
            'section' => 'business_networking_conference_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 2 */
    $wp_customize->add_setting(
        'business_networking_conference_social_link_2',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'business_networking_conference_social_link_2',
        array(
            'label' => esc_html__( 'Add Twitter Link', 'business-networking-conference' ),
            'section' => 'business_networking_conference_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 3 */
    $wp_customize->add_setting(
        'business_networking_conference_social_link_3',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'business_networking_conference_social_link_3',
        array(
            'label' => esc_html__( 'Add Instagram Link', 'business-networking-conference' ),
            'section' => 'business_networking_conference_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 4 */
    $wp_customize->add_setting(
        'business_networking_conference_social_link_4',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'business_networking_conference_social_link_4',
        array(
            'label' => esc_html__( 'Add Pintrest Link', 'business-networking-conference' ),
            'section' => 'business_networking_conference_social_section_settings',
            'type' => 'url',
        )
    );

    /** Socail Section Settings End */


    /** Home Page Settings */
    $wp_customize->add_panel( 
        'business_networking_conference_home_page_settings',
         array(
            'priority' => 9,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Home Page Settings', 'business-networking-conference' ),
            'description' => esc_html__( 'Customize Home Page Settings', 'business-networking-conference' ),
        ) 
    );

    /** Slider Section Settings */
    $wp_customize->add_section(
        'business_networking_conference_slider_section_settings',
        array(
            'title' => esc_html__( 'Slider Section Settings', 'business-networking-conference' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'business_networking_conference_home_page_settings',
        )
    );

    /** Slider Section control */
    $wp_customize->add_setting( 
        'business_networking_conference_slider_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_slider_setting',
        array(
            'label'       => __( 'Show Slider', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_slider_section_settings',
            'type'        => 'checkbox',
        )
    );
    
    $categories = get_categories();
        $cat_posts = array();
            $i = 0;
            $cat_posts[]='Select';
        foreach($categories as $category){
            if($i==0){
            $default = $category->slug;
            $i++;
        }
        $cat_posts[$category->slug] = $category->name;
    }

    $wp_customize->add_setting(
        'business_networking_conference_blog_slide_category',
        array(
            'default'   => 'select',
            'sanitize_callback' => 'business_networking_conference_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'business_networking_conference_blog_slide_category',
        array(
            'type'    => 'select',
            'choices' => $cat_posts,
            'label' => __('Select Category to display Slides','business-networking-conference'),
            'section' => 'business_networking_conference_slider_section_settings',
        )
    );

    /** About Section Settings */
    
    $wp_customize->add_section( 'business_networking_conference_section_featured_about',
        array(
        'title'      => __( 'About Us Section', 'business-networking-conference' ),
        'priority'   => 110,
        'capability' => 'edit_theme_options',
        'panel' => 'business_networking_conference_home_page_settings',
        )
    );

    /** About Section control */
    $wp_customize->add_setting( 
        'business_networking_conference_about_setting', 
        array(
            'default'           => false,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_about_setting',
        array(
            'label'       => __( 'Show / Hide About', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_section_featured_about',
            'type'        => 'checkbox',
        )
    );

     // Section Sub Title
    $wp_customize->add_setting('business_networking_conference_about_top_text', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('business_networking_conference_about_top_text', 
        array(
        'label'       => __('About Us Batch', 'business-networking-conference'),
        'section'     => 'business_networking_conference_section_featured_about',   
        'settings'    => 'business_networking_conference_about_top_text',
        'type'        => 'text'
        )
    );

     // Section Sub Title
    $wp_customize->add_setting('business_networking_conference_about_text_extra', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('business_networking_conference_about_text_extra', 
        array(
        'label'       => __('About Us Extra Title', 'business-networking-conference'),
        'section'     => 'business_networking_conference_section_featured_about',   
        'settings'    => 'business_networking_conference_about_text_extra',
        'type'        => 'text'
        )
    );

    // Section Title
    $wp_customize->add_setting('business_networking_conference_featured_mission_section_title', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('business_networking_conference_featured_mission_section_title', 
        array(
        'label'       => __('Section Title', 'business-networking-conference'),
        'section'     => 'business_networking_conference_section_featured_about',   
        'settings'    => 'business_networking_conference_featured_mission_section_title',
        'type'        => 'text'
        )
    );

    // Post
    $wp_customize->add_setting('business_networking_conference_featured_mission_post_', 
        array(
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'business_networking_conference_dropdown_pages'
        )
    );

    $wp_customize->add_control('business_networking_conference_featured_mission_post_', 
        array(
        'label'       => __('Pages Dropdown', 'business-networking-conference'),
        'section'     => 'business_networking_conference_section_featured_about',   
        'settings'    => 'business_networking_conference_featured_mission_post_',
        'type'        => 'dropdown-pages',
        )
    );


    // Section Title
    $wp_customize->add_setting('business_networking_conference_image_text', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('business_networking_conference_image_text', 
        array(
        'label'       => __('Years Of Experience', 'business-networking-conference'),
        'section'     => 'business_networking_conference_section_featured_about',   
        'settings'    => 'business_networking_conference_image_text',
        'type'        => 'text'
        )
    );
    
    /** Home Page Settings Ends */
    
    /** Footer Section */
    $wp_customize->add_section(
        'business_networking_conference_footer_section',
        array(
            'title' => __( 'Footer Settings', 'business-networking-conference' ),
            'priority' => 70,
            'panel' => 'business_networking_conference_home_page_settings',
        )
    );

    /** Footer Copyright control */
    $wp_customize->add_setting( 
        'business_networking_conference_footer_setting', 
        array(
            'default' => true,
            'sanitize_callback' => 'business_networking_conference_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'business_networking_conference_footer_setting',
        array(
            'label'       => __( 'Show Footer Copyright', 'business-networking-conference' ),
            'section'     => 'business_networking_conference_footer_section',
            'type'        => 'checkbox',
        )
    );
    
    /** Copyright Text */
    $wp_customize->add_setting(
        'business_networking_conference_footer_copyright_text',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'business_networking_conference_footer_copyright_text',
        array(
            'label' => __( 'Copyright Info', 'business-networking-conference' ),
            'section' => 'business_networking_conference_footer_section',
            'type' => 'text',
        )
    );  
$wp_customize->add_setting('business_networking_conference_footer_background_image',
        array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
        )
    );


    $wp_customize->add_control(
         new WP_Customize_Cropped_Image_Control($wp_customize, 'business_networking_conference_footer_background_image',
            array(
                'label' => esc_html__('Footer Background Image', 'business-networking-conference'),
                'description' => sprintf(esc_html__('Recommended Size %1$s px X %2$s px', 'business-networking-conference'), 1024, 800),
                'section' => 'business_networking_conference_footer_section',
                'width' => 1024,
                'height' => 800,
                'flex_width' => true,
                'flex_height' => true,
            )
        )
    );

    /** Footer Background Image Attachment */
    $wp_customize->add_setting('business_networking_conference_background_attatchment', array(
        'default'           => 'scroll',
        'sanitize_callback' => 'business_networking_conference_sanitize_choices',
    ));

    $wp_customize->add_control('business_networking_conference_background_attatchment', array(
        'label'    => __('Footer Background Attachment', 'business-networking-conference'),
        'section'  => 'business_networking_conference_footer_section',
        'settings' => 'business_networking_conference_background_attatchment',
        'type'     => 'select',
        'choices'  => array(
            'fixed' => __('fixed','business-networking-conference'),
            'scroll' => __('scroll','business-networking-conference'),
        ),
    ));

    /* Footer Background Color*/
    $wp_customize->add_setting(
        'business_networking_conference_footer_background_color',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'business_networking_conference_footer_background_color',
            array(
                'label' => __('Footer Widget Area Background Color', 'business-networking-conference'),
                'section' => 'business_networking_conference_footer_section',
                'type' => 'color',
            )
        )
    );

     $wp_customize->add_setting('business_networking_conference_scroll_icon',array(
        'default'   => 'fas fa-arrow-up',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Business_Networking_Conference_Changeable_Icon(
        $wp_customize,'business_networking_conference_scroll_icon',array(
        'label' => __('Scroll Top Icon','business-networking-conference'),
        'transport' => 'refresh',
        'section'   => 'business_networking_conference_footer_section',
        'type'      => 'icon'
    )));

    $wp_customize->add_setting('business_networking_conference_scroll_top_alignment',array(
        'default' => 'right-align',
        'sanitize_callback' => 'business_networking_conference_sanitize_scroll_top_alignment'
    ));
    $wp_customize->add_control('business_networking_conference_scroll_top_alignment',array(
        'type' => 'select',
        'label' => __('Scroll Top Alignment','business-networking-conference'),
        'section' => 'business_networking_conference_footer_section',
        'choices' => array(
            'right-align' => __('Right Alignment','business-networking-conference'),
            'center-align' => __('Center Alignment','business-networking-conference'),
            'left-align' => __('Left Alignment','business-networking-conference'),
        ),
    ) );

    /** Scroll to top button shape */
    $wp_customize->add_setting('business_networking_conference_scroll_to_top_radius', array(
        'default'           => 'curved-box',
        'sanitize_callback' => 'business_networking_conference_sanitize_choices',
    ));

    $wp_customize->add_control('business_networking_conference_scroll_to_top_radius', array(
        'label'    => __('Scroll Top Button Shape', 'business-networking-conference'),
        'section'  => 'business_networking_conference_footer_section',
        'settings' => 'business_networking_conference_scroll_to_top_radius',
        'type'     => 'select',
        'choices'  => array(
            'box'        => __( 'Box', 'business-networking-conference' ),
            'curved-box' => __( 'Curved Box', 'business-networking-conference' ),
            'circle'     => __( 'Circle', 'business-networking-conference' ),
        ),
    ));

    // 404 PAGE SETTINGS
    $wp_customize->add_section(
        'business_networking_conference_404_section',
        array(
            'title' => __( '404 Page Settings', 'business-networking-conference' ),
            'priority' => 70,
            'panel' => 'business_networking_conference_general_settings',
        )
    );
   
    $wp_customize->add_setting('404_page_image', array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw', // Sanitize as URL
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, '404_page_image', array(
        'label' => __('404 Page Image', 'business-networking-conference'),
        'section' => 'business_networking_conference_404_section',
        'settings' => '404_page_image',
    )));

    $wp_customize->add_setting('404_pagefirst_header', array(
        'default' => __('404', 'business-networking-conference'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_pagefirst_header', array(
        'type' => 'text',
        'label' => __('Heading', 'business-networking-conference'),
        'section' => 'business_networking_conference_404_section',
    ));

    // Setting for 404 page header
    $wp_customize->add_setting('404_page_header', array(
        'default' => __('Sorry, that page can\'t be found!', 'business-networking-conference'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_page_header', array(
        'type' => 'text',
        'label' => __('Heading', 'business-networking-conference'),
        'section' => 'business_networking_conference_404_section',
    ));

}
add_action( 'customize_register', 'business_networking_conference_customize_register' );
endif;

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function business_networking_conference_customize_preview_js() {
    // Use minified libraries if SCRIPT_DEBUG is false
    $business_networking_conference_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $business_networking_conference_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script( 'business_networking_conference_customizer', get_template_directory_uri() . '/js' . $business_networking_conference_build . '/customizer' . $business_networking_conference_suffix . '.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'business_networking_conference_customize_preview_js' );