<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package business_networking_conference
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function business_networking_conference_body_classes( $classes ) {
  global $business_networking_conference_post;
  
    if( !is_page_template( 'template-home.php' ) ){
        $classes[] = 'inner';
        // Adds a class of group-blog to blogs with more than 1 published author.
    }

    if ( is_multi_author() ) {
        $classes[] = 'group-blog ';
    }

    // Adds a class of custom-background-image to sites with a custom background image.
    if ( get_background_image() ) {
        $classes[] = 'custom-background-image';
    }
    
    // Adds a class of custom-background-color to sites with a custom background color.
    if ( get_background_color() != 'ffffff' ) {
        $classes[] = 'custom-background-color';
    }
    

    if( business_networking_conference_woocommerce_activated() && ( is_shop() || is_product_category() || is_product_tag() || 'product' === get_post_type() ) && ! is_active_sidebar( 'shop-sidebar' ) ){
        $classes[] = 'full-width';
    }    

    // Adds a class of hfeed to non-singular pages.
    if ( ! is_page() ) {
        $classes[] = 'hfeed ';
    }
  
    if( is_404() ||  is_search() ){
        $classes[] = 'full-width';
    }
  
    if( ! is_active_sidebar( 'right-sidebar' ) ) {
        $classes[] = 'full-width'; 
    }

    return $classes;
}
add_filter( 'body_class', 'business_networking_conference_body_classes' );

 /**
 * 
 * @link http://www.altafweb.com/2011/12/remove-specific-tag-from-php-string.html
 */
function business_networking_conference_strip_single( $tag, $string ){
    $string=preg_replace('/<'.$tag.'[^>]*>/i', '', $string);
    $string=preg_replace('/<\/'.$tag.'>/i', '', $string);
    return $string;
}

if ( ! function_exists( 'business_networking_conference_excerpt_more' ) ) :
/**
 * Replaces "[...]" (appended to automatically generated excerpts) with ... * 
 */
function business_networking_conference_excerpt_more($more) {
  return is_admin() ? $more : ' &hellip; ';
}
endif;
add_filter( 'excerpt_more', 'business_networking_conference_excerpt_more' );

if( ! function_exists( 'business_networking_conference_footer_credit' ) ):
/**
 * Footer Credits
*/
function business_networking_conference_footer_credit() {

    // Check if footer copyright is enabled
    $business_networking_conference_show_footer_copyright = get_theme_mod( 'business_networking_conference_footer_setting', true );

    if ( ! $business_networking_conference_show_footer_copyright ) {
        return; 
    }
    $business_networking_conference_copyright_text = get_theme_mod('business_networking_conference_footer_copyright_text');

    $business_networking_conference_text = '<div class="site-info"><div class="container"><span class="copyright">';
    if ($business_networking_conference_copyright_text) {
        $business_networking_conference_text .= wp_kses_post($business_networking_conference_copyright_text); 
    } else {
        $business_networking_conference_text .= esc_html__('&copy; ', 'business-networking-conference') . date_i18n(esc_html__('Y', 'business-networking-conference')); 
        $business_networking_conference_text .= ' <a href="' . esc_url(home_url('/')) . '">' . esc_html(get_bloginfo('name')) . '</a>' . esc_html__('. All Rights Reserved.', 'business-networking-conference');
    }
    $business_networking_conference_text .= '</span>';
    $business_networking_conference_text .= '<span class="by"> <a href="' . esc_url('https://www.themeignite.com/products/free-conference-wordpress-theme') . '" rel="nofollow" target="_blank">' . BUSINESS_NETWORKING_CONFERENCE_THEME_NAME . '</a>' . esc_html__(' By ', 'business-networking-conference') . '<a href="' . esc_url('https://themeignite.com/') . '" rel="nofollow" target="_blank">' . esc_html__('Themeignite', 'business-networking-conference') . '</a>.';
    $business_networking_conference_text .= sprintf(esc_html__(' Powered By %s', 'business-networking-conference'), '<a href="' . esc_url(__('https://wordpress.org/', 'business-networking-conference')) . '" target="_blank">WordPress</a>.');
    if (function_exists('the_privacy_policy_link')) {
        $business_networking_conference_text .= get_the_privacy_policy_link();
    }
    $business_networking_conference_text .= '</span></div></div>';
    echo apply_filters('business_networking_conference_footer_text', $business_networking_conference_text);
}
add_action('business_networking_conference_footer', 'business_networking_conference_footer_credit');
endif;


/**
 * Is Woocommerce activated
*/
if ( ! function_exists( 'business_networking_conference_woocommerce_activated' ) ) {
  function business_networking_conference_woocommerce_activated() {
    if ( class_exists( 'woocommerce' ) ) { return true; } else { return false; }
  }
}

if( ! function_exists( 'business_networking_conference_change_comment_form_default_fields' ) ) :
/**
 * Change Comment form default fields i.e. author, email & url.
 * https://blog.josemcastaneda.com/2016/08/08/copy-paste-hurting-theme/
*/
function business_networking_conference_change_comment_form_default_fields( $fields ){    
    // get the current commenter if available
    $business_networking_conference_commenter = wp_get_current_commenter();
 
    // core functionality
    $req      = get_option( 'require_name_email' );
    $business_networking_conference_aria_req = ( $req ? " aria-required='true'" : '' );
    $business_networking_conference_required = ( $req ? " required" : '' );
    $business_networking_conference_author   = ( $req ? __( 'Name*', 'business-networking-conference' ) : __( 'Name', 'business-networking-conference' ) );
    $business_networking_conference_email    = ( $req ? __( 'Email*', 'business-networking-conference' ) : __( 'Email', 'business-networking-conference' ) );
 
    // Change just the author field
    $fields['author'] = '<p class="comment-form-author"><label class="screen-reader-text" for="author">' . esc_html__( 'Name', 'business-networking-conference' ) . '<span class="required">*</span></label><input id="author" name="author" placeholder="' . esc_attr( $business_networking_conference_author ) . '" type="text" value="' . esc_attr( $business_networking_conference_commenter['comment_author'] ) . '" size="30"' . $business_networking_conference_aria_req . $business_networking_conference_required . ' /></p>';
    
    $fields['email'] = '<p class="comment-form-email"><label class="screen-reader-text" for="email">' . esc_html__( 'Email', 'business-networking-conference' ) . '<span class="required">*</span></label><input id="email" name="email" placeholder="' . esc_attr( $business_networking_conference_email ) . '" type="text" value="' . esc_attr(  $business_networking_conference_commenter['comment_author_email'] ) . '" size="30"' . $business_networking_conference_aria_req . $business_networking_conference_required. ' /></p>';
    
    $fields['url'] = '<p class="comment-form-url"><label class="screen-reader-text" for="url">' . esc_html__( 'Website', 'business-networking-conference' ) . '</label><input id="url" name="url" placeholder="' . esc_attr__( 'Website', 'business-networking-conference' ) . '" type="text" value="' . esc_attr( $business_networking_conference_commenter['comment_author_url'] ) . '" size="30" /></p>'; 
    
    return $fields;    
}
endif;
add_filter( 'comment_form_default_fields', 'business_networking_conference_change_comment_form_default_fields' );

if( ! function_exists( 'business_networking_conference_change_comment_form_defaults' ) ) :
/**
 * Change Comment Form defaults
 * https://blog.josemcastaneda.com/2016/08/08/copy-paste-hurting-theme/
*/
function business_networking_conference_change_comment_form_defaults( $defaults ){    
    $defaults['comment_field'] = '<p class="comment-form-comment"><label class="screen-reader-text" for="comment">' . esc_html__( 'Comment', 'business-networking-conference' ) . '</label><textarea id="comment" name="comment" placeholder="' . esc_attr__( 'Comment', 'business-networking-conference' ) . '" cols="45" rows="8" aria-required="true" required></textarea></p>';
    
    return $defaults;    
}
endif;
add_filter( 'comment_form_defaults', 'business_networking_conference_change_comment_form_defaults' );

if( ! function_exists( 'business_networking_conference_escape_text_tags' ) ) :
/**
 * Remove new line tags from string
 *
 * @param $text
 * @return string
 */
function business_networking_conference_escape_text_tags( $text ) {
    return (string) str_replace( array( "\r", "\n" ), '', strip_tags( $text ) );
}
endif;

if( ! function_exists( 'wp_body_open' ) ) :
/**
 * Fire the wp_body_open action.
 * Added for backwards compatibility to support pre 5.2.0 WordPress versions.
*/
function wp_body_open() {
    /**
     * Triggered after the opening <body> tag.
    */
    do_action( 'wp_body_open' );
}
endif;

if ( ! function_exists( 'business_networking_conference_get_fallback_svg' ) ) :    
/**
 * Get Fallback SVG
*/
function business_networking_conference_get_fallback_svg( $business_networking_conference_post_thumbnail ) {
    if( ! $business_networking_conference_post_thumbnail ){
        return;
    }
    
    $business_networking_conference_image_size = business_networking_conference_get_image_sizes( $business_networking_conference_post_thumbnail );
     
    if( $business_networking_conference_image_size ){ ?>
        <div class="svg-holder">
             <svg class="fallback-svg" viewBox="0 0 <?php echo esc_attr( $business_networking_conference_image_size['width'] ); ?> <?php echo esc_attr( $business_networking_conference_image_size['height'] ); ?>" preserveAspectRatio="none">
                    <rect width="<?php echo esc_attr( $business_networking_conference_image_size['width'] ); ?>" height="<?php echo esc_attr( $business_networking_conference_image_size['height'] ); ?>" style="fill:#dedddd;"></rect>
            </svg>
        </div>
        <?php
    }
}
endif;

function business_networking_conference_enqueue_google_fonts() {

    require get_template_directory() . '/inc/wptt-webfont-loader.php';

    wp_enqueue_style(
        'google-fonts-open-sans',
        wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300..800;1,300..800&display=swap' ),
        array(),
        '1.0'
    );

    wp_enqueue_style(
        'google-fonts-poppins',
        wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap' ),
        array(),
        '1.0'
    );
}
add_action( 'wp_enqueue_scripts', 'business_networking_conference_enqueue_google_fonts' );


if( ! function_exists( 'business_networking_conference_site_branding' ) ) :
/**
 * Site Branding
*/
function business_networking_conference_site_branding(){
    $business_networking_conference_logo_site_title = get_theme_mod( 'header_site_title', 0 );
    $business_networking_conference_tagline = get_theme_mod( 'header_tagline', false );
    $business_networking_conference_logo_width = get_theme_mod('logo_width', 100); // Retrieve the logo width setting

    ?>
    <div class="site-branding" style="max-width: <?php echo esc_attr(get_theme_mod('logo_width', '-1'))?>px;">
        <?php 
        // Check if custom logo is set and display it
        if (function_exists('has_custom_logo') && has_custom_logo()) {
            the_custom_logo();
        }
        if ($business_networking_conference_logo_site_title):
             if (is_front_page()): ?>
            <h1 class="site-title" style="font-size: <?php echo esc_attr(get_theme_mod('business_networking_conference_site_title_size', '30')); ?>px;">
            <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
          </h1>
            <?php else: ?>
                <p class="site-title" itemprop="name">
                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                </p>
            <?php endif; ?>
        <?php endif; 
    
        if ($business_networking_conference_tagline) :
            $business_networking_conference_description = get_bloginfo('description', 'display');
            if ($business_networking_conference_description || is_customize_preview()) :
        ?>
                <p class="site-description" itemprop="description"><?php echo $business_networking_conference_description; ?></p>
            <?php endif;
        endif;
        ?>
    </div>
    <?php
}
endif;
if( ! function_exists( 'business_networking_conference_navigation' ) ) :
    /**
     * Site Navigation
    */
    function business_networking_conference_navigation(){
        ?>
        <nav class="main-navigation" id="site-navigation" role="navigation">
            <?php 
            wp_nav_menu( array( 
                'theme_location' => 'primary', 
                'menu_id' => 'primary-menu' 
            ) ); 
            ?>
        </nav>
        <?php
    }
endif;

if( ! function_exists( 'business_networking_conference_header' ) ) :
    /**
     * Header Start
    */
    function business_networking_conference_header(){
        $business_networking_conference_header_image = get_header_image();
        $business_networking_conference_sticky_header = get_theme_mod('business_networking_conference_sticky_header');
        $business_networking_conference_phone        = get_theme_mod( 'business_networking_conference_header_phone' );
        $business_networking_conference_social_icon = get_theme_mod( 'business_networking_conference_social_icon_setting', false);
        $business_networking_conference_header_setting     = get_theme_mod( 'business_networking_conference_header_setting', false );
        $business_networking_conference_email        = get_theme_mod( 'business_networking_conference_header_email' );
        $business_networking_conference_timing     = get_theme_mod( 'business_networking_conference_header_timing' );
        ?>
        <div id="page-site-header" class="main-header">
            <header id="masthead" class="site-header header-inner" role="banner">
                    <div class="topbar">
                        <div class="container-fluid">
                        <div class="row top-head">
                            <div class="col-xl-1 col-lg-1 col-md-1"></div>
                            <div class="col-xl-5 col-lg-5 col-md-3 align-self-center header-detail text-md-start">
                               <?php if ( $business_networking_conference_social_icon ){?>
                                    <div class="social-links">
                                        <?php 
                                        $business_networking_conference_social_link1 = get_theme_mod( 'business_networking_conference_social_link_1' );
                                        $business_networking_conference_social_link2 = get_theme_mod( 'business_networking_conference_social_link_2' );
                                        $business_networking_conference_social_link3 = get_theme_mod( 'business_networking_conference_social_link_3' );
                                        $business_networking_conference_social_link4 = get_theme_mod( 'business_networking_conference_social_link_4' );

                                        if ( ! empty( $business_networking_conference_social_link1 ) ) {
                                            echo '<a class="social1" href="' . esc_url( $business_networking_conference_social_link1 ) . '" target="_blank"><i class="fab fa-facebook-f"></i></a>';
                                        }
                                        if ( ! empty( $business_networking_conference_social_link2 ) ) {
                                            echo '<a class="social2" href="' . esc_url( $business_networking_conference_social_link2 ) . '" target="_blank"><i class="fab fa-twitter"></i></a>';
                                        } 
                                        if ( ! empty( $business_networking_conference_social_link3 ) ) {
                                            echo '<a class="social3" href="' . esc_url( $business_networking_conference_social_link3 ) . '" target="_blank"><i class="fab fa-instagram"></i></a>';
                                        }
                                        if ( ! empty( $business_networking_conference_social_link4 ) ) {
                                            echo '<a class="social4" href="' . esc_url( $business_networking_conference_social_link4 ) . '" target="_blank"><i class="fab fa-pinterest-p"></i></a>';
                                        }
                                        ?>
                                    </div>
                                <?php } ?>  
                            </div>
                            <div class="col-xl-6 col-lg-6 col-md-8 align-self-center text-md-end text-lg-end info-box">
                                <?php if ( $business_networking_conference_phone ){?>
                                    <span class="location-1">
                                        <span class="contact-icon">
                                            <i class="fas fa-phone-alt"></i>
                                        </span>
                                        <span class="contact-box">
                                             <span class="location-text">
                                                <a href="tel:<?php echo esc_attr($business_networking_conference_phone);?>">
                                                    <?php echo esc_html( $business_networking_conference_phone);?>
                                                </a>
                                            </span>
                                        </span>
                                    </span>
                                <?php } ?>
                                <?php if ( $business_networking_conference_email ){?>
                                    <span class="location">
                                        <span class="contact-icon">
                                            <i class="fa-solid fa-envelope"></i>
                                        </span>
                                        <span class="contact-box">
                                            <span class="location-text">
                                                <a href="mailto:<?php echo esc_attr($business_networking_conference_email);?>">
                                                    <?php echo esc_html($business_networking_conference_email);?>
                                                </a>
                                            </span>
                                        </span>
                                    </span>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    </div>
                    <div class="theme-menu head_bg" style="background-image: url('<?php echo esc_url( $business_networking_conference_header_image ); ?>');" data-sticky="<?php echo $business_networking_conference_sticky_header; ?>">
                        <div class="container">
                            <div class="row">
                            <div class="col-xl-3 col-lg-3 col-md-12 align-self-center">
                                <?php business_networking_conference_site_branding(); ?>
                            </div>
                            <div class="col-xl-9 col-lg-8 col-md-12 align-self-center">
                               <?php business_networking_conference_navigation(); ?> 
                            </div>
                        </div>
                        </div>
                    </div>
                    
            </header>
        </div>
        <?php
    }
endif;
add_action( 'business_networking_conference_header', 'business_networking_conference_header', 20 );
