<?php
$gridchamp_recentblog_status = esc_attr(get_theme_mod('recent_post_status'));
if($gridchamp_recentblog_status){?>
<div class="walker-wraper recentblog-wraper">
	<div class="walker-container">
		<div class="walkerwp-grid-12">
			<?php 
			if(get_theme_mod('recentpost_heading_text') ){
				echo '<h2 class="section-heading">'.esc_html(get_theme_mod('recentpost_heading_text')).'</h2>';
			}
			if(get_theme_mod('recentpost_desc_text') ){
				echo '<p class="section-subheader">'.esc_html(get_theme_mod('recentpost_desc_text')).'</p>';
			}?>
		</div>
	</div>
	<div class="walker-container post-list">
		<?php $recent_post_type = esc_attr(get_theme_mod('recent_blog_home'));
			if($recent_post_type=='latest-post'){
				$sticky = get_option( 'sticky_posts' );
				$gridchamp_query = new WP_Query( array( 'post_type' => 'post', 'order'=> 'DESC', 'posts_per_page' => 3, 
					'ignore_sticky_posts' => 1,'post__not_in' => $sticky) );
					    while ($gridchamp_query->have_posts()) : $gridchamp_query->the_post();?>
					    <div class="walkerwp-grid-4">
					    	<div class="walkerwp-recentpost-box">
						  	<?php 
						    	if ( has_post_thumbnail() ) {?>
						    		<div class="thumbnail-box">
									<a href="<?php the_permalink();?>" class="home-post-thumbnails"><?php the_post_thumbnail();?></a>
										<?php $archive_year  = get_the_time('Y'); $archive_month_letter = get_the_time('M'); $archive_month = get_the_time('m'); $archive_day = get_the_time('d'); ?></a>
                    				<a class="post-date-stamp"
                            href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                            <span class="post-date-day"><?php echo $archive_day; ?></span>
                            <span class="post-date-month"><?php echo $archive_month_letter; ?></span>
                        	
                    
									</a>
								</div>
								<?php } ?>
								<div class="content-part <?php echo esc_attr($content_part_class);?>">
									<?php

									if(!has_post_thumbnail()){ $archive_year  = get_the_time('Y'); $archive_month_letter = get_the_time('M'); $archive_month = get_the_time('m'); $archive_day = get_the_time('d'); ?>
                    				<a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
			                            <?php echo __( 'Posted On','business-launcher' );?> <span class="post-date-day"> <?php echo $archive_day; ?></span>
			                            <span class="post-date-month"><?php echo $archive_month_letter; ?></span>
			                        	</a>
			                        <?php } ?>
									<h3><a href="<?php echo the_permalink();?>"><?php  the_title(); ?></a></h3>	
									<p><?php echo esc_html(gridchamp_excerpt( 25 )); ?></p>
									<a href="<?php the_permalink();?>" class="gridchamp-primary-button details-service style-extend"> <?php echo esc_html(get_theme_mod('recentpost_readmore_text'));?></a>
									
								</div>
							
							</div>
						</div>
						<?php endwhile; 
				wp_reset_postdata(); 
			} else{
				$recent_post_cat = esc_attr(get_theme_mod('gridchamp_recent_category'));
				$sticky = get_option( 'sticky_posts' );
				$gridchamp_query = new WP_Query( array( 'post_type' => 'post', 'order'=> 'DESC', 'posts_per_page' => 3, 'category_name' => $recent_post_cat,
					'ignore_sticky_posts' => 1,'post__not_in' => $sticky) );
					    while ($gridchamp_query->have_posts()) : $gridchamp_query->the_post();?>
					    <div class="walkerwp-grid-4">
					    	<div class="walkerwp-recentpost-box">
						  	<?php 
						    	if ( has_post_thumbnail() ) {?>
						    		<div class="thumbnail-box">
									<a href="<?php the_permalink();?>" class="home-post-thumbnails"><?php the_post_thumbnail();?></a>
										<?php $archive_year  = get_the_time('Y'); $archive_month_letter = get_the_time('M'); $archive_month = get_the_time('m'); $archive_day = get_the_time('d'); ?></a>
                    				<a class="post-date-stamp"
                            href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                            <span class="post-date-day"><?php echo $archive_day; ?></span>
                            <span class="post-date-month"><?php echo $archive_month_letter; ?></span>
                        	
                    
									</a>
								</div>
								<?php } ?>
								<?php if(!has_post_thumbnail()){
									$content_part_class="without-thumbnail";
								} else{
									$content_part_class="without-thumbnail";
								}?>
								<div class="content-part <?php echo esc_attr($content_part_class);?>">
									<?php

									if(!has_post_thumbnail()){ $archive_year  = get_the_time('Y'); $archive_month_letter = get_the_time('M'); $archive_month = get_the_time('m'); $archive_day = get_the_time('d'); ?>
                    				<a 
                            href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                            <?php echo __( 'Posted On','business-launcher' );?> <span class="post-date-day"> <?php echo $archive_day; ?></span>
                            <span class="post-date-month"><?php echo $archive_month_letter; ?></span>
                        	</a>
                        <?php } ?>
									<h3><a href="<?php echo the_permalink();?>"><?php  the_title(); ?></a></h3>	
									<p><?php echo esc_html(gridchamp_excerpt( 25 )); ?></p>
									<?php 
									if(get_theme_mod('recentpost_readmore_text')){
										$recent_more_text = get_theme_mod('recentpost_readmore_text');
									}else{
										$recent_more_text = __('Read More','business-launcher');
									}
									?>
									<a href="<?php the_permalink();?>" class="gridchamp-primary-button details-service outline-style"> <?php echo esc_html($recent_more_text);?></a>
									
								</div>
								
							
							</div>
						</div>
						<?php endwhile; 
				wp_reset_postdata(); 
			}
		?>	
	</div>
</div>
<?php } ?>