<?php
if ( ! function_exists( 'business_launcher_setup' ) ) :
	function business_launcher_setup() {
		add_theme_support( "title-tag");
		add_theme_support( 'automatic-feed-links' );
	}
endif;
add_action( 'after_setup_theme', 'business_launcher_setup' );


function business_launcher_enqueue_styles() {
    wp_enqueue_style( 'gridchamp-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'business-launcher-style',get_stylesheet_directory_uri() . '/style.css',array('gridchamp-style'));
}
add_action( 'wp_enqueue_scripts', 'business_launcher_enqueue_styles' );


function business_launcher_customizer_default_settings() {
	set_theme_mod( 'gridchamp_primary_color', '#30c1b7' );
	set_theme_mod( 'gridchamp_secondary_color', '#f34e4e' );
	set_theme_mod('gridchamp_about_bg_color','#ffffff');
	set_theme_mod('cta_bg_color','#30c1b7');
	set_theme_mod('gridchamp_service_section_padding_top','70');
	set_theme_mod('gridchamp_extra_cta_section_padding_top','70');
	set_theme_mod('gridchamp_extra_cta_section_padding_bottom','70');
	set_theme_mod('slider_primary_btn_color','#ffffff');
	set_theme_mod('slider_primary_btn_hover_color','#30c1b7');
	set_theme_mod('subheader_bg_color','#30c1b7');
	set_theme_mod('banner_image_opacity','0.546');
	set_theme_mod('gridchamp_footer_bg_color','#232323');
	set_theme_mod('gridchamp_heading_fonts','Playfair Display:400,700,400italic');
}
add_action( 'after_switch_theme', 'business_launcher_customizer_default_settings' );

if ( ! function_exists( 'business_launcher_footer_copyright' ) ) :
	function business_launcher_footer_copyright() {
		$gridchamp_copyright = get_theme_mod('footer_copiright_text');
		if(get_theme_mod('copyright_text_alignment') =='copyright-text-align-left'){
			$copyright_text_align_class ="text-left";
		}else{
			$copyright_text_align_class ="text-center";
		}
		if($gridchamp_copyright && gridchamp_set_to_premium() ){?>
			<div class="site-info walkerwp-grid-12 <?php echo esc_attr($copyright_text_align_class);?>"><?php echo wp_kses_post($gridchamp_copyright);?></div>
		<?php } else{ ?>
			<div class="site-info walkerwp-grid-12 <?php echo esc_attr($copyright_text_align_class);?>">
				<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'business-launcher' ) ); ?>">
					<?php
					/* translators: %s: CMS name, i.e. WordPress. */
					printf( esc_html__( 'Proudly powered by %s', 'business-launcher' ), 'WordPress' );
					?>
				</a>
				<span class="sep"> | </span>
					<?php
					/* translators: 1: Theme name, 2: Theme author. */
					printf( esc_html__( 'Theme: %1$s by %2$s.', 'business-launcher' ), 'Business Launcher', '<a href="http://walkerwp.com/">WalkerWP</a>' );
					?>
			</div><!-- .site-info -->
		<?php } ?>
	<?php }
endif;


function business_launcher_dynamic_style() {
    wp_enqueue_style(
        'custom-style',
        get_stylesheet_directory_uri() . '/style.css'
    );
    if(gridchamp_set_to_premium()){
        if(get_theme_mod( 'gridchamp_footer_bg_color')){
            $footer_widgets_bg = sanitize_hex_color(get_theme_mod( 'gridchamp_footer_bg_color','#000000'));
    	}else{
         	$footer_widgets_bg = '#000000';
   		}
   	}else{
		$footer_widgets_bg = '#000000';
   	}
    $my_custom_css = "
        .walker-wraper.footer-widgets-wraper:before{
        	background:$footer_widgets_bg !important;
    }";
    wp_add_inline_style( 'custom-style', $my_custom_css );
}
add_action( 'wp_enqueue_scripts', 'business_launcher_dynamic_style' );
?>