<?php
/**
 *  Template Name: Front Page for Theme
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package business_launcher
 */


get_header(); ?>
<?php

if(gridchamp_set_to_premium()){

	$default_order = array( 'extra-cta','about-us','grid-counter', 'services', 'portfolio','team', 'features','products','pricing-table','testimonial','cta','recentpost','faqs','brands','newsletter');
	$gridchamp_sections = get_theme_mod( 'gridchamp_section_order', $default_order );
	
		if( !empty($gridchamp_sections) ):
			foreach ($gridchamp_sections as $section) {
				//echo $section;
				switch ( $section ) {
					case "extra-cta":
						gridchamp_cta_section();
					break;
					case "about-us":
						gridchamp_homesection_about();
					break;
					case "grid-counter":
						gridchamp_counter_section();
					break;
					case "services":
						gridchamp_homesection_services();
					break;
					case "portfolio":
						gridchamp_homesection_portfolios();
					break;
					case "team":
						gridchamp_homesection_team();
					break;
					case "features":
						gridchamp_homesection_features();
					break;
					case "products":
						gridchamp_homesection_products();
					break;
					case "pricing-table":
						gridchamp_pricing_tables();
					break;
					case "testimonial":
						gridchamp_homesection_testimonials();
					break;
					case "cta":
						gridchamp_homesection_cta();
					break;
					case "recentpost":
						gridchamp_homesection_blogs();
					break;
					case "faqs":
						gridchamp_homesection_faqs();
					break;
					case "brands":
						gridchamp_homesection_brands();
					break;
					case "newsletter":
						gridchamp_form_section();
					break;
				}
			}
		endif;
}else{
	get_template_part( 'template-parts/partials/about/aboutus');
	get_template_part( 'template-parts/partials/cta/extra-cta');
	get_template_part( 'template-parts/partials/services/services');
	get_template_part( 'template-parts/partials/testimonial/testimonials');
	get_template_part( 'template-parts/partials/blogs/recentblogs');
	get_template_part( 'template-parts/partials/cta/cta');
	
	
}


?>

<?php get_footer();