<?php
/**
 * Title: Service One
 * Slug: business-indexy/service-one
 * Categories: business-indexy
 *
 * @link       https://fremontbusinessindex.com/
 * @since      1.0.0
 *
 * @package    business-indexy
 */

?>

<!-- wp:group {"className":"is-style-business-indexy-y60","backgroundColor":"base-3","layout":{"type":"constrained"}} -->
<div class="wp-block-group is-style-business-indexy-y60 has-base-3-background-color has-background">
    
    <!-- wp:heading {"textAlign":"center","level":4,"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent"}}}},"textColor":"accent"} -->
    <h4 class="wp-block-heading has-text-align-center has-accent-color has-text-color has-link-color"><?php esc_html_e( 'Our Services', 'business-indexy' ); ?></h4>
    <!-- /wp:heading -->

    <!-- wp:heading -->
    <h2 class="wp-block-heading"><?php esc_html_e( 'We specialize in helping small and mid-sized businesses scale sustainably through proven frameworks and systems.', 'business-indexy' ); ?></h2>
    <!-- /wp:heading -->

    <!-- wp:columns {"align":"wide","className":"is-style-business-indexy-t50g40"} -->
    <div class="wp-block-columns alignwide is-style-business-indexy-t50g40">
        
        <!-- wp:column -->
        <div class="wp-block-column">
            
            <!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}},"border":{"radius":"6px"}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
            <div class="wp-block-group has-base-2-background-color has-background" style="border-radius:6px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
                
                <!-- wp:image {"id":1856,"sizeSlug":"full","linkDestination":"none"} -->
                <figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_theme_file_uri( 'assets/images/64-1.png' ) ); ?>" alt="" class="wp-image-1856"/></figure>
                <!-- /wp:image -->

                <!-- wp:heading {"style":{"spacing":{"padding":{"right":"var:preset|spacing|40"}}},"fontSize":"large"} -->
                <h2 class="wp-block-heading has-large-font-size" style="padding-right:var(--wp--preset--spacing--40)"><?php esc_html_e( 'Data-driven insights', 'business-indexy' ); ?></h2>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"className":"is-style-business-indexy-t10"} -->
                <p class="is-style-business-indexy-t10"><?php esc_html_e( 'We provide data-driven insights to help you make smarter business decisions and stay ahead of competitors.', 'business-indexy' ); ?></p>
                <!-- /wp:paragraph -->

                <!-- wp:list {"className":"is-style-business-indexy-about"} -->
                <ul class="wp-block-list is-style-business-indexy-about">
                    
                    <!-- wp:list-item {"className":"is-style-business-indexy-about-item","style":{"spacing":{"padding":{"right":"0"}}}} -->
                    <li class="is-style-business-indexy-about-item" style="padding-right:0"><?php esc_html_e( 'Data-driven insights', 'business-indexy' ); ?></li>
                    <!-- /wp:list-item -->

                    <!-- wp:list-item {"className":"is-style-business-indexy-about-item","style":{"spacing":{"padding":{"right":"0"}}}} -->
                    <li class="is-style-business-indexy-about-item" style="padding-right:0"><?php esc_html_e( 'Smarter business decisions', 'business-indexy' ); ?></li>
                    <!-- /wp:list-item -->

                    <!-- wp:list-item {"className":"is-style-business-indexy-about-item","style":{"spacing":{"padding":{"right":"0"}}}} -->
                    <li class="is-style-business-indexy-about-item" style="padding-right:0"><?php esc_html_e( 'Ahead of competitors', 'business-indexy' ); ?></li>
                    <!-- /wp:list-item -->

                </ul>
                <!-- /wp:list -->

            </div>
            <!-- /wp:group -->

        </div>
        <!-- /wp:column -->

        <!-- wp:column -->
        <div class="wp-block-column">
            
            <!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}},"border":{"radius":"6px"}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
            <div class="wp-block-group has-base-2-background-color has-background" style="border-radius:6px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
                
                <!-- wp:image {"id":1856,"sizeSlug":"full","linkDestination":"none"} -->
                <figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_theme_file_uri( 'assets/images/64-1.png' ) ); ?>" alt="" class="wp-image-1856"/></figure>
                <!-- /wp:image -->

                <!-- wp:heading {"style":{"spacing":{"padding":{"right":"var:preset|spacing|40"}}},"fontSize":"large"} -->
                <h2 class="wp-block-heading has-large-font-size" style="padding-right:var(--wp--preset--spacing--40)"><?php esc_html_e( 'Strategy to execution', 'business-indexy' ); ?></h2>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"className":"is-style-business-indexy-t10"} -->
                <p class="is-style-business-indexy-t10"><?php esc_html_e( 'We provide data-driven insights to help you make smarter business decisions and stay ahead of competitors.', 'business-indexy' ); ?></p>
                <!-- /wp:paragraph -->

                <!-- wp:list {"className":"is-style-business-indexy-about"} -->
                <ul class="wp-block-list is-style-business-indexy-about">
                    
                    <!-- wp:list-item {"className":"is-style-business-indexy-about-item","style":{"spacing":{"padding":{"right":"0"}}}} -->
                    <li class="is-style-business-indexy-about-item" style="padding-right:0"><?php esc_html_e( 'Data-driven insights', 'business-indexy' ); ?></li>
                    <!-- /wp:list-item -->

                    <!-- wp:list-item {"className":"is-style-business-indexy-about-item","style":{"spacing":{"padding":{"right":"0"}}}} -->
                    <li class="is-style-business-indexy-about-item" style="padding-right:0"><?php esc_html_e( 'Smarter business decisions', 'business-indexy' ); ?></li>
                    <!-- /wp:list-item -->

                    <!-- wp:list-item {"className":"is-style-business-indexy-about-item","style":{"spacing":{"padding":{"right":"0"}}}} -->
                    <li class="is-style-business-indexy-about-item" style="padding-right:0"><?php esc_html_e( 'Ahead of competitors', 'business-indexy' ); ?></li>
                    <!-- /wp:list-item -->

                </ul>
                <!-- /wp:list -->

            </div>
            <!-- /wp:group -->

        </div>
        <!-- /wp:column -->

        <!-- wp:column -->
        <div class="wp-block-column">
            
            <!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}},"border":{"radius":"6px"}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
            <div class="wp-block-group has-base-2-background-color has-background" style="border-radius:6px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
                
                <!-- wp:image {"id":1856,"sizeSlug":"full","linkDestination":"none"} -->
                <figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_theme_file_uri( 'assets/images/64-1.png' ) ); ?>" alt="" class="wp-image-1856"/></figure>
                <!-- /wp:image -->

                <!-- wp:heading {"style":{"spacing":{"padding":{"right":"var:preset|spacing|40"}}},"fontSize":"large"} -->
                <h2 class="wp-block-heading has-large-font-size" style="padding-right:var(--wp--preset--spacing--40)"><?php esc_html_e( 'Streamline operations', 'business-indexy' ); ?></h2>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"className":"is-style-business-indexy-t10"} -->
                <p class="is-style-business-indexy-t10"><?php esc_html_e( 'We provide data-driven insights to help you make smarter business decisions and stay ahead of competitors.', 'business-indexy' ); ?></p>
                <!-- /wp:paragraph -->

                <!-- wp:list {"className":"is-style-business-indexy-about"} -->
                <ul class="wp-block-list is-style-business-indexy-about">
                    
                    <!-- wp:list-item {"className":"is-style-business-indexy-about-item","style":{"spacing":{"padding":{"right":"0"}}}} -->
                    <li class="is-style-business-indexy-about-item" style="padding-right:0"><?php esc_html_e( 'Data-driven insights', 'business-indexy' ); ?></li>
                    <!-- /wp:list-item -->

                    <!-- wp:list-item {"className":"is-style-business-indexy-about-item","style":{"spacing":{"padding":{"right":"0"}}}} -->
                    <li class="is-style-business-indexy-about-item" style="padding-right:0"><?php esc_html_e( 'Smarter business decisions', 'business-indexy' ); ?></li>
                    <!-- /wp:list-item -->

                    <!-- wp:list-item {"className":"is-style-business-indexy-about-item","style":{"spacing":{"padding":{"right":"0"}}}} -->
                    <li class="is-style-business-indexy-about-item" style="padding-right:0"><?php esc_html_e( 'Ahead of competitors', 'business-indexy' ); ?></li>
                    <!-- /wp:list-item -->

                </ul>
                <!-- /wp:list -->

            </div>
            <!-- /wp:group -->

        </div>
        <!-- /wp:column -->

    </div>
    <!-- /wp:columns -->

</div>
<!-- /wp:group -->
