<?php
/**
 * Title: Hero
 * Slug: business-indexy/hero
 * Categories: business-indexy
 *
 * @link       https://fremontbusinessindex.com/
 * @since      1.0.0
 *
 * @package    business-indexy
 */

?>

<!-- wp:group {"className":"business-indexy-no-gap","style":{"background":{"backgroundImage":{"url":"<?php echo esc_url( get_theme_file_uri( 'assets/images/hero/hero-1.webp' ) ); ?>","id":2084,"source":"file","title":"hero-02-2-min"},"backgroundSize":"cover"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group business-indexy-no-gap">
    
    <!-- wp:group {"align":"full","className":"is-style-business-indexy-hero-bg","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"}}},"layout":{"type":"constrained"}} -->
    <div class="wp-block-group alignfull is-style-business-indexy-hero-bg" style="padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)">
        
        <!-- wp:columns {"align":"wide"} -->
        <div class="wp-block-columns alignwide">
            
            <!-- wp:column -->
            <div class="wp-block-column">
                
                <!-- wp:heading {"style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base","fontSize":"xxx-large"} -->
                <h2 class="wp-block-heading has-base-color has-text-color has-link-color has-xxx-large-font-size"><?php esc_html_e( 'Maximize your business potential', 'business-indexy' ); ?></h2>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"style":{"spacing":{"padding":{"right":"var:preset|spacing|50"}},"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}}},"textColor":"base-2"} -->
                <p class="has-base-2-color has-text-color has-link-color" style="padding-right:var(--wp--preset--spacing--50)"><?php esc_html_e( 'Growing a business is about consistently delivering value, building strong relationships, and adapting quickly to changing needs and opportunities.', 'business-indexy' ); ?></p>
                <!-- /wp:paragraph -->

                <!-- wp:buttons -->
                <div class="wp-block-buttons">
                    
                    <!-- wp:button {"className":"is-style-business-indexy-rounded-b3"} -->
                    <div class="wp-block-button is-style-business-indexy-rounded-b3">
                        <a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'View Solutions', 'business-indexy' ); ?></a>
                    </div>
                    <!-- /wp:button -->
                    
                </div>
                <!-- /wp:buttons -->

            </div>
            <!-- /wp:column -->

            <!-- wp:column -->
            <div class="wp-block-column">


            </div>
            <!-- /wp:column -->

        </div>
        <!-- /wp:columns -->

    </div>
    <!-- /wp:group -->

</div>
<!-- /wp:group -->
