<?php
/**
 * Title: Header One Dark
 * Slug: business-indexy/header-one-dark
 * Categories: business-indexy
 *
 * @link       https://fremontbusinessindex.com/
 * @since      1.0.0
 *
 * @package    business-indexy
 */

?>

<!-- wp:group {"className":"is-style-business-indexy-header-one-dark"} -->
<div class="wp-block-group is-style-business-indexy-header-one-dark">

	<!-- wp:group {"className":"business-indexy-header-one-dark-top","layout":{"type":"constrained"}} -->
	<div class="wp-block-group business-indexy-header-one-dark-top">
		<!-- wp:paragraph {"className":"business-indexy-header-one-dark-top-phone"} -->
		<p class="business-indexy-header-one-dark-top-phone"><?php esc_html_e( '(123) 456 789', 'business-indexy' ); ?></p>
		<!-- /wp:paragraph -->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"className":"business-indexy-header-one-dark-main","layout":{"type":"constrained"}} -->
	<div class="wp-block-group business-indexy-header-one-dark-main">

		<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|40"}}}} -->
		<div class="wp-block-columns alignwide">

            <!-- wp:column {"width":"20%","className":"business-indexy-header-one-dark-logo"} -->
            <div class="wp-block-column business-indexy-header-one-dark-logo" style="flex-basis:20%">
				<?php if ( function_exists( 'the_custom_logo' ) && has_custom_logo() ) : ?>
				<!-- wp:site-logo {"width":200,"shouldSyncIcon":true} /-->
				<?php else : ?>
                <!-- wp:site-title {"className":"is-style-business-indexy-header-one-title-dark"} /-->
                <?php endif; ?>
                <!-- wp:paragraph {"className":"business-indexy-header-one-dark-icon"} -->
                <p class="business-indexy-header-one-dark-icon"><a href=""></a></p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:column -->

			<!-- wp:column {"width":"60%","className":"business-indexy-header-one-dark-nav"} -->
			<div class="wp-block-column business-indexy-header-one-dark-nav" style="flex-basis:60%">
				<!-- wp:navigation {"ref":4,"overlayMenu":"never","align":"wide","className":"is-style-business-indexy-dark-menu","layout":{"type":"flex","justifyContent":"right"}} /-->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"width":"20%","className":"business-indexy-header-one-dark-cta"} -->
			<div class="wp-block-column business-indexy-header-one-dark-cta" style="flex-basis:20%">
				<!-- wp:pattern {"slug":"business-indexy/header-phone-one-dark"} /-->
			</div>
			<!-- /wp:column -->

		</div>
		<!-- /wp:columns -->

	</div>
	<!-- /wp:group -->

	<!-- wp:group {"align":"full","className":"business-indexy-header-one-dark-meta","layout":{"type":"constrained"}} -->
	<div class="wp-block-group alignfull business-indexy-header-one-dark-meta">

		<!-- wp:columns {"align":"wide"} -->
		<div class="wp-block-columns alignwide">

			<!-- wp:column {"width":"66.66%","className":"business-indexy-header-one-dark-contact"} -->
			<div class="wp-block-column business-indexy-header-one-dark-contact" style="flex-basis:66.66%">

				<!-- wp:paragraph -->
				<p>
					<strong><?php esc_html_e( 'Address', 'business-indexy' ); ?>:</strong><?php esc_html_e( '34 Gillon Rd, Grenada, Mississippi(MS), 38901', 'business-indexy' ); ?>
				</p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph -->
				<p>
					<strong><?php esc_html_e( 'Email', 'business-indexy' ); ?>:</strong><?php esc_html_e( 'info@example.com', 'business-indexy' ); ?>
				</p>
				<!-- /wp:paragraph -->

			</div>
			<!-- /wp:column -->

			<!-- wp:column {"width":"33.33%"} -->
			<div class="wp-block-column" style="flex-basis:33.33%">

				<!-- wp:social-links {"align":"right","className":"is-style-logos-only business-indexy-header-one-dark-social"} -->
				<ul class="wp-block-social-links alignright is-style-logos-only business-indexy-header-one-dark-social">

					<!-- wp:social-link {"url":"#","service":"instagram"} /-->
					<!-- wp:social-link {"url":"#","service":"facebook"} /-->
					<!-- wp:social-link {"url":"#","service":"x"} /-->
					<!-- wp:social-link {"url":"#","service":"linkedin"} /-->

				</ul>
				<!-- /wp:social-links -->

			</div>
			<!-- /wp:column -->

		</div>
		<!-- /wp:columns -->

	</div>
	<!-- /wp:group -->

</div>
<!-- /wp:group -->
